package edu.unika.aifb.rdf.rdfserver.interfaces;

import javax.rmi.PortableRemoteObject;
import javax.naming.NamingException;
import javax.naming.InitialContext;
import java.util.Hashtable;

public class CounterUtil
{
   // Home interface lookup methods

   /**
    * Obtain remote home interface from default initial context
    * @return Home interface for Counter. Lookup using JNDI_NAME
    */
   public static edu.unika.aifb.rdf.rdfserver.interfaces.CounterHome getHome() throws NamingException
   {
      InitialContext initialContext = new InitialContext();
      try {
         java.lang.Object objRef = initialContext.lookup(edu.unika.aifb.rdf.rdfserver.interfaces.CounterHome.JNDI_NAME);
         edu.unika.aifb.rdf.rdfserver.interfaces.CounterHome home = (edu.unika.aifb.rdf.rdfserver.interfaces.CounterHome)PortableRemoteObject.narrow(objRef, edu.unika.aifb.rdf.rdfserver.interfaces.CounterHome.class);
         return home;
      } finally {
         initialContext.close();
      }
   }

   /**
    * Obtain remote home interface from parameterised initial context
    * @param environment Parameters to use for creating initial context
    * @return Home interface for Counter. Lookup using JNDI_NAME
    */
   public static edu.unika.aifb.rdf.rdfserver.interfaces.CounterHome getHome( Hashtable environment ) throws NamingException
   {
      InitialContext initialContext = new InitialContext(environment);
      try {
         java.lang.Object objRef = initialContext.lookup(edu.unika.aifb.rdf.rdfserver.interfaces.CounterHome.JNDI_NAME);
         edu.unika.aifb.rdf.rdfserver.interfaces.CounterHome home = (edu.unika.aifb.rdf.rdfserver.interfaces.CounterHome)PortableRemoteObject.narrow(objRef, edu.unika.aifb.rdf.rdfserver.interfaces.CounterHome.class);
         return home;
      } finally {
         initialContext.close();
      }
   }

}
