package edu.unika.aifb.rdf.rdfserver.ejb;

import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.EJBException;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import java.rmi.RemoteException;

import edu.unika.aifb.rdf.rdfserver.interfaces.Node;
import edu.unika.aifb.rdf.rdfserver.interfaces.Model;
import edu.unika.aifb.rdf.rdfserver.interfaces.ModelHome;
import edu.unika.aifb.rdf.rdfserver.interfaces.ModelUtil;
import edu.unika.aifb.rdf.rdfserver.interfaces.Resource;
import edu.unika.aifb.rdf.rdfserver.interfaces.ResourceHome;
import edu.unika.aifb.rdf.rdfserver.interfaces.ResourceUtil;
import edu.unika.aifb.rdf.rdfserver.interfaces.StatementInfo;
import edu.unika.aifb.rdf.rdfserver.interfaces.Literal;
import edu.unika.aifb.rdf.rdfserver.interfaces.LiteralHome;
import edu.unika.aifb.rdf.rdfserver.interfaces.LiteralUtil;

/**
 * @ejb.bean name="Statement" cmp-version="2.x" type="CMP" jndi-name="ejb/kaon/Statement" primkey-field="id"
 * @ejb.interface remote-class="edu.unika.aifb.rdf.rdfserver.interfaces.Statement"
 * @ejb.pk class="java.lang.Integer"
 * @ejb.transaction type="Required"
 *
 * @ejb.finder signature="java.util.Collection findByModelKey(java.lang.String model)"
 *             query="SELECT OBJECT(s) FROM Statement s WHERE s.modelKey=?1"
 *
 * @ejb.finder signature="java.util.Collection findByModelSubject(java.lang.String model, java.lang.Integer subj_id)"
 *             query="SELECT OBJECT(s) FROM Statement s WHERE s.modelKey=?1 AND s.subjKey=?2"
 *
 * @ejb.finder signature="java.util.Collection findByModelPredicate(java.lang.String model, java.lang.Integer pred_id)"
 *             query="SELECT OBJECT(s) FROM Statement s WHERE s.modelKey=?1 AND s.predKey=?2"
 *
 * @ejb.finder signature="java.util.Collection findByModelObject(java.lang.String model, java.lang.Integer obj_id, java.lang.Boolean type)"
 *             query="SELECT OBJECT(s) FROM Statement s WHERE s.modelKey=?1 AND s.objKey=?2 AND s.literal=?3"
 *
 * @ejb.finder signature="java.util.Collection findByModelPredObj(java.lang.String model, java.lang.Integer pred_id, java.lang.Integer obj, java.lang.Boolean type)"
 *             query="SELECT OBJECT(s) FROM Statement s WHERE s.modelKey=?1 AND s.predKey=?2 AND s.objKey=?3 AND s.literal=?4"
 *
 * @ejb.finder signature="java.util.Collection findByModelSubjObj(java.lang.String model, java.lang.Integer subj_id, java.lang.Integer obj, java.lang.Boolean type)"
 *             query="SELECT OBJECT(s) FROM Statement s WHERE s.modelKey=?1 AND s.subjKey=?2 AND s.objKey=?3 AND s.literal=?4"
 *
 * @ejb.finder signature="java.util.Collection findByModelSubjPred(java.lang.String model, java.lang.Integer subj_id, java.lang.Integer pred_id)"
 *             query="SELECT OBJECT(s) FROM Statement s WHERE s.modelKey=?1 AND s.subjKey=?2 AND s.predKey=?3"
 *
 * @ejb.finder signature="java.util.Collection findByAllAttributes(java.lang.String model, java.lang.Integer subj_id, java.lang.Integer pred_id, java.lang.Integer obj, java.lang.Boolean type)"
 *             query="SELECT OBJECT(s) FROM Statement s WHERE s.modelKey=?1 AND s.subjKey=?2 AND s.predKey=?3 AND s.objKey=?4 AND s.literal=?5"
 *
 * @ejb.ejb-ref ejb-name="Model"
 * @ejb.ejb-ref ejb-name="Resource"
 * @ejb.ejb-ref ejb-name="Literal"
 * @ejb.ejb-ref ejb-name="Counter"
 *
 * @jboss.create-table "${jboss.create.table}"
 * @jboss.remove-table "${jboss.remove.table}"
 * @jboss.tuned-updates "${jboss.tuned.updates}"
 * @jboss.read-only "${jboss.read.only}"
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public abstract class StatementBean extends CountedBeanBase implements EntityBean {
    protected ModelHome m_modelHome;
    protected LiteralHome m_literalHome;
    protected ResourceHome m_resourceHome;
    protected edu.unika.aifb.rdf.rdfserver.interfaces.StatementHome m_statementHome;

    public void setEntityContext(EntityContext entityContext) throws EJBException {
        super.setEntityContext(entityContext);
        try {
            m_modelHome=ModelUtil.getHome();
            m_literalHome=LiteralUtil.getHome();
            m_resourceHome=ResourceUtil.getHome();
            m_statementHome=(edu.unika.aifb.rdf.rdfserver.interfaces.StatementHome)entityContext.getEJBHome();
        }
        catch (Exception e) {
            throw new EJBException(e.getMessage());
        }
    }
    public void unsetEntityContext() throws EJBException {
        super.unsetEntityContext();
        m_modelHome=null;
        m_literalHome=null;
        m_resourceHome=null;
        m_statementHome=null;
    }
    protected String getBeanType() {
        return "statement";
    }

    /**
     * @ejb.create-method
     * @ejb.transaction type="Required"
     */
    public Integer ejbCreate(String modelID,int subjectID,int predicateID,int objectID,boolean isLiteral) {
        setId(getNextKey());
        setModelKey(modelID);
        setSubjKey(subjectID);
        setPredKey(predicateID);
        setObjKey(objectID);
        setLiteral(isLiteral);
        return null;
    }
    public void ejbPostCreate(String modelID,int subjectID,int predicateID,int objectID,boolean isLiteral) {
    }

    /**
     * @ejb.pk-field
     * @ejb.persistent-field
     */
    public abstract Integer getId();
    public abstract void setId(Integer id);

    /**
     * @ejb.interface-method
     * @ejb.persistent-field
     */
    public abstract String getModelKey();
    /**
     * @ejb.interface-method
     */
    public abstract void setModelKey(String value);

    /**
     * @ejb.persistent-field
     * @ejb.interface-method
     */
    public abstract int getSubjKey();
    public abstract void setSubjKey(int value);

    /**
     * @ejb.persistent-field
     * @ejb.interface-method
     */
    public abstract int getPredKey();
    public abstract void setPredKey(int value);

    /**
     * @ejb.persistent-field
     * @ejb.interface-method
     */
    public abstract int getObjKey();
    public abstract void setObjKey(int value);

    /**
     * @ejb.persistent-field
     * @ejb.interface-method
     */
    public abstract boolean getLiteral();
    public abstract void setLiteral(boolean lit);

    /**
    * @return information about this bean
    * @ejb.interface-method
    * @ejb.transaction type="Supports"
    */
    public StatementInfo getStatementInfo() throws FinderException,RemoteException {
        return new StatementInfo(getId(),getModelKey(),getSubject().getLabel(),getPredicate().getLabel(),getObject().getLabel(),getLiteral());
    }

    /**
    * @return the subject of this statement
    * @ejb.interface-method
    * @ejb.transaction type="Supports"
    */
    public Resource getSubject() throws FinderException, RemoteException {
        return m_resourceHome.findByPrimaryKey(new Integer(getSubjKey()));
    }

    /**
     * @return predicate of this statement
     * @ejb.interface-method
     * @ejb.transaction type="Supports"
     */
    public Resource getPredicate() throws FinderException, RemoteException {
        return m_resourceHome.findByPrimaryKey(new Integer(getPredKey()));
    }

    /**
     * @return object of this statement
     * @ejb.interface-method
     * @ejb.transaction type="Supports"
     */
    public Node getObject() throws FinderException, RemoteException {
        return getLiteral() ? (Node)getObjLit() : (Node)getObjRes();
    }

    protected Resource getObjRes() throws FinderException, RemoteException {
        return m_resourceHome.findByPrimaryKey(new Integer(getObjKey()));
    }

    protected Literal getObjLit() throws FinderException, RemoteException {
        return m_literalHome.findByPrimaryKey(new Integer(getObjKey()));
    }

    /**
     * @return the model that contains this statement
     * @ejb.interface-method
     * @ejb.transaction type="Supports"
     */
    public Model getModel() throws FinderException, RemoteException {
        return m_modelHome.findByPrimaryKey(getModelKey());
    }

}
