package edu.unika.aifb.rdf.rdfserver.ejb;

import javax.ejb.EntityBean;
import javax.ejb.CreateException;

/**
 * @ejb.bean name="Literal" cmp-version="2.x" type="CMP" jndi-name="ejb/kaon/Literal" primkey-field="id"
 * @ejb.interface extends="edu.unika.aifb.rdf.rdfserver.interfaces.Node"
 * @ejb.pk class="java.lang.Integer"
 * @ejb.transaction type="Required"
 *
 * @ejb.finder signature="java.util.Collection findByLabel(java.lang.String label)"
 *             query="SELECT OBJECT(l) FROM Literal l WHERE l.label=?1"
 *
 * @ejb.ejb-ref ejb-name="Counter"
 *
 * @jboss.create-table "${jboss.create.table}"
 * @jboss.remove-table "${jboss.remove.table}"
 * @jboss.tuned-updates "${jboss.tuned.updates}"
 * @jboss.read-only "${jboss.read.only}"
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public abstract class LiteralBean extends CountedBeanBase implements EntityBean {

    protected String getBeanType() {
        return "literal";
    }

    /**
     * @ejb.interface-method
     * @ejb.persistent-field
     *
     * @jboss.sql-type VARCHAR(255)
     */
    public abstract String getLabel();
    /**
     * @ejb.interface-method
     */
    public abstract void setLabel(String label);

    /**
     * @ejb.pk-field
     * @ejb.persistent-field
     */
    public abstract Integer getId();
    public abstract void setId(Integer id);

    /**
     * @ejb.create-method
     */
    public Integer ejbCreate(String label) {
        setId(getNextKey());
        setLabel(label);
        return null;
    }
    public void ejbPostCreate(String label) {
    }
}
