package edu.unika.aifb.rdf.rdfserver.ejb;

import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.CreateException;
import javax.ejb.RemoveException;

/**
 * @ejb.bean name="Counter" cmp-version="2.x" type="CMP" jndi-name="ejb/kaon/Counter" primkey-field="type"
 * @ejb.interface remote-class="edu.unika.aifb.rdf.rdfserver.interfaces.Counter"
 * @ejb.pk class="java.lang.String"
 * @ejb.transaction type="Supports"
 *
 * @jboss.create-table "${jboss.create.table}"
 * @jboss.remove-table "${jboss.remove.table}"
 * @jboss.tuned-updates "${jboss.tuned.updates}"
 * @jboss.read-only "${jboss.read.only}"
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public abstract class CounterBean implements EntityBean {

    /**
     * @ejb.pk-field
     * @ejb.persistent-field
     * @ejb.transaction type="Supports"
     *
     * @jboss.sql-type VARCHAR(255)
     */
    public abstract String getType();
    public abstract void setType(String label);

    /**
     * @ejb.interface-method
     * @ejb.persistent-field
     *
     * @jboss.column-name "counter"
     * @jboss.sql-type INTEGER
     */
    public abstract Integer getCounter();
    /**
     * Sets the current value of this bean's counter.
     */
    public abstract void setCounter(Integer counter);

    /**
     * Returns the next counter value.
     * @ejb.interface-method
     * @ejb.transaction type="Required"
     */
    public Integer getNextCounterValue() {
        Integer current = getCounter();
        Integer newValue = new Integer(current.intValue() + 1);
        setCounter(newValue);
        return newValue;
    }

    /**
     * @ejb.create-method
     * @ejb.transaction type="Required"
     */
    public String ejbCreate(String type) {
        setType(type);
        setCounter(new Integer(0));
        return null;
    }
    public void ejbPostCreate(String type) {
    }
    public void ejbLoad() {
    }
    public void ejbStore() {
    }
    public void ejbActivate() {
    }
    public void ejbPassivate() {
    }
    public void ejbRemove() {
    }
    public void setEntityContext(EntityContext entityContext) {
    }
    public void unsetEntityContext() {
    }
}
