package edu.unika.aifb.rdf.rdfserver.ejb;

import javax.ejb.EntityContext;
import javax.ejb.EJBException;
import javax.ejb.RemoveException;
import javax.ejb.FinderException;

import edu.unika.aifb.rdf.rdfserver.interfaces.Counter;
import edu.unika.aifb.rdf.rdfserver.interfaces.CounterHome;
import edu.unika.aifb.rdf.rdfserver.interfaces.CounterUtil;

/**
 * Base class for all beans whose primary key is generated through CounterBean.
 *
 * @author Raphael Volz (volz@aifb.uni-karlsruhe.de)
 * @author Boris Motik (boris.motik@fzi.de)
 */
public abstract class CountedBeanBase {
    protected EntityContext m_entityContext;
    protected Counter m_counter;

    public void setEntityContext(EntityContext entityContext) throws EJBException {
        m_entityContext=entityContext;
        try {
            CounterHome home=CounterUtil.getHome();
            try {
                m_counter=home.findByPrimaryKey(getBeanType());
            }
            catch (FinderException e) {
                m_counter=home.create(getBeanType());
            }
        }
        catch (Exception e) {
            throw new EJBException(e.getMessage());
        }
    }
    public void unsetEntityContext() throws EJBException {
        m_counter=null;
        m_entityContext=null;
    }
    protected abstract String getBeanType();
    protected Integer getNextKey() {
        try {
            return m_counter.getNextCounterValue();
        }
        catch (Exception e) {
            throw new EJBException(e.getMessage());
        }
    }
    public void ejbLoad() {
    }
    public void ejbStore() {
    }
    public void ejbActivate() {
    }
    public void ejbPassivate() {
    }
    public void ejbRemove() {
    }
}
