package edu.unika.aifb.rdf.rdfserver.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import javax.ejb.FinderException;
import javax.ejb.CreateException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import edu.unika.aifb.rdf.api.util.RDFFactory;
import edu.unika.aifb.rdf.api.util.RDFManager;
import edu.unika.aifb.rdf.api.model.Model;
import edu.unika.aifb.rdf.api.model.NodeFactory;
import edu.unika.aifb.rdf.api.model.ModelException;
import edu.unika.aifb.rdf.rdfserver.interfaces.RemoteConnection;

/**
 * An implementation of the RDF factory for remote models.
 */
public class RemoteRDFFactory implements RDFFactory {
    static {
        RDFManager.registerFactory(new RemoteRDFFactory());
    }

    /**
     * Creates an instance of this class.
     */
    protected RemoteRDFFactory() {
    }
    /**
     * Create an empty model. If this factory cannot service this URI, <code>null</code> should be returned.
     *
     * @param uri           URI of the model
     * @param nodeFactory   the node factory
     * @return              new model or <code>null</code> if model with given URI cannot be created by this implementation
     */
    public Model createModel(String uri,NodeFactory nodeFactory) throws ModelException {
        URI uriObject;
        try {
            uriObject=new URI(uri);
        }
        catch (URISyntaxException e) {
            return null;
        }
        if ("jboss".equals(uriObject.getScheme()))
            try {
                String alias=uriObject.getPath();
                if (alias.startsWith("/"))
                    alias=alias.substring(1);
                RemoteConnection connection=new RemoteConnection(uriObject.getHost(),uriObject.getPort());
                return new RemoteModel(connection.createModel(alias),nodeFactory,uri);
            }
            catch (RemoteException e) {
                throw new ModelException("Remote method invocation error",e);
            }
            catch (CreateException e) {
                throw new ModelException("Error creating model",e);
            }
            catch (NamingException e) {
                throw new ModelException("Error creating model",e);
            }
        return null;
    }
    /**
     * Opens an existing model. If this factory cannot service this URI, <code>null</code> should be returned.
     *
     * @param uri           URI of the model
     * @param nodeFactory   the node factory
     * @return              model or <code>null</code> if model with given URI cannot be created by this implementation
     */
    public RDFManager.ModelInfo openModelEx(String uri,NodeFactory nodeFactory) throws ModelException {
        URI uriObject;
        try {
            uriObject=new URI(uri);
        }
        catch (URISyntaxException e) {
            return null;
        }
        if ("jboss".equals(uriObject.getScheme()))
            try {
                String alias=uriObject.getPath();
                if (alias.startsWith("/"))
                    alias=alias.substring(1);
                RemoteConnection connection=new RemoteConnection(uriObject.getHost(),uriObject.getPort());
                RDFManager.ModelInfo modelInfo=new RDFManager.ModelInfo();
                modelInfo.m_model=new RemoteModel(connection.loadModel(alias),nodeFactory,uri);
                modelInfo.m_includedModels=new String[0][0];
                return modelInfo;
            }
            catch (RemoteException e) {
                throw new ModelException("Remote method invocation error",e);
            }
            catch (FinderException e) {
                throw new ModelException("Error creating model",e);
            }
            catch (NamingException e) {
                throw new ModelException("Error creating model",e);
            }
        return null;
    }
    /**
     * Deletes an existing model. If this factory cannot service this URI, <code>false</code> should be returned.
     *
     * @param uri           URI of the model
     * @return              <code>true</code> if this factory could delete the model
     */
    public boolean deleteModel(String uri) throws ModelException {
        URI uriObject;
        try {
            uriObject=new URI(uri);
        }
        catch (URISyntaxException e) {
            return false;
        }
        if ("jboss".equals(uriObject.getScheme()))
            try {
                String alias=uriObject.getPath();
                if (alias.startsWith("/"))
                    alias=alias.substring(1);
                RemoteConnection connection=new RemoteConnection(uriObject.getHost(),uriObject.getPort());
                connection.loadModel(alias).remove();
            }
            catch (RemoteException e) {
                throw new ModelException("Remote method invocation error",e);
            }
            catch (FinderException e) {
                throw new ModelException("Error creating model",e);
            }
            catch (RemoveException e) {
                throw new ModelException("Error creating model",e);
            }
            catch (NamingException e) {
                throw new ModelException("Error creating model",e);
            }
        return false;
    }
}
