package edu.unika.aifb.rdf.rdfcrawler;

import java.net.URL;
import java.net.MalformedURLException;
import java.util.Set;
import java.util.HashSet;
import java.util.List;
import java.util.Iterator;

/**
 * The class HostFilter checks whether the URL
 * string belongs to the given set of hosts.
 * HostFilter may be used to narrow the set of downloadable documents
 */

public class HostFilter {
    /** Set of eligible hosts, if host filtering is enabled */
    private Set m_hosts;

    /** Initializes the set of eligible hosts */
    public HostFilter(List rawhosts) throws MalformedURLException {
        m_hosts=new HashSet();
        Iterator iterator=rawhosts.iterator();
        while (iterator.hasNext()) {
            String host=(String)iterator.next();
            URL url=new URL(host);
            m_hosts.add(url.getHost());
        }
    }
    public void assertIsInFilter(String host) throws FilterException {
        if (!m_hosts.contains(host))
            throw new FilterException("Host '"+host+"' is not in the filter.");
    }
    public String toString() {
        StringBuffer buffer=new StringBuffer("<rdf:Description about='http://TheCrawler'>");
        Iterator iterator=m_hosts.iterator();
        while (iterator.hasNext()) {
            buffer.append("    <a:HostRestriction rdf:resource='http://");
            buffer.append((String)iterator.next());
            buffer.append("'/>\n");
        }
        buffer.append("</rdf:Description>");
        return buffer.toString();
    }
}

