package edu.unika.aifb.rdf.rdfcrawler;

import java.util.*;

import edu.unika.aifb.rdf.api.model.*;

/**
 * An individual channel which waits for the
 * work to be done with web page retrieving,
 * tries out Cache, NetRetrieve and finally
 * passes filepath to DocProcessor and gets
 * back
 * 1) a piece of RDF model
 * 2) all the URIs which have to be tested/crawled
 *    as they appear in the given URI
 * 3) exceptions (if any)
 */
public class Channel implements Runnable {
    protected ChannelPool m_pool;
    protected Cache m_cache;
    protected Model m_model;

    public Channel(ChannelPool pool) {
        m_pool=pool;
        m_cache=m_pool.getCache();
        m_model=m_pool.getModel();
    }

    public void run() {
        URLStruct url=m_pool.getUnprocessedURL();
        while (url!=null) {
            try {
                processURL(url);
                m_pool.markURLProcessed(url);
            }
            catch (Exception e) {
                m_pool.markURLInError(url,e);
            }
            url=m_pool.getUnprocessedURL();
        }
        m_pool.channelTerminating();
    }
    protected void processURL(URLStruct url) throws Exception {
        DocInstance docinstance = new DocInstance(m_cache,url);
        docinstance.analyzeHTML();
        docinstance.analyzeRDF();
        Iterator iterator=docinstance.getUri().iterator();
        while (iterator.hasNext()) {
            String item=(String)iterator.next();
            m_pool.addUnprocessedURL(item,url.getURL(),true);
        }
        iterator=docinstance.getNs().iterator();
        while (iterator.hasNext()) {
            String item=(String)iterator.next();
            m_pool.addUnprocessedURL(item,url.getURL(),false);
        }
        iterator=docinstance.getRdf().iterator();
        while (iterator.hasNext()) {
            Statement statement=(Statement)iterator.next();
            synchronized (m_model) {
                try {
                    m_model.add(statement);
                }
                catch (ModelException ignored) {
                }
            }
        }
    }
}
