package edu.unika.aifb.rdf.mainmemory.test;

import junit.framework.TestCase;

import edu.unika.aifb.rdf.api.model.*;
import edu.unika.aifb.rdf.api.util.*;

/**
 * Test cases for ModelContext.
 */
public class TestModelContext extends TestCase {
    protected static final String CR=System.getProperty("line.separator");
    protected static final String MODEL1_PHYSICAL=TestModelContext.class.getResource("res/model1.xml").toString();
    protected static final String MODEL2_PHYSICAL=TestModelContext.class.getResource("res/model2.xml").toString();
    protected static final String MODEL3_PHYSICAL=TestModelContext.class.getResource("res/model3.xml").toString();
    protected static final String CYCLE1_PHYSICAL=TestModelContext.class.getResource("res/cycle1.xml").toString();
    protected static final String CYCLE2_PHYSICAL=TestModelContext.class.getResource("res/cycle2.xml").toString();

    protected ModelContext m_modelContext;

    public TestModelContext(String name) {
        super(name);
    }
    protected void setUp() throws Exception {
        m_modelContext=new ModelContext();
        m_modelContext.mapLogicalToPhysicalURI("http://test.org/model1.xml",MODEL1_PHYSICAL);
    }
    protected void assertContains(Model model,String subject,String predicate,String object,boolean isLiteral) throws Exception {
        NodeFactory nodeFactory=model.getNodeFactory();
        Resource sub=nodeFactory.createResource(subject);
        Resource pred=nodeFactory.createResource(predicate);
        RDFNode obj;
        if (isLiteral)
            obj=nodeFactory.createLiteral(object);
        else
            obj=nodeFactory.createResource(object);
        Statement statement=nodeFactory.createStatement(sub,pred,obj);
        assertTrue(model.contains(statement));
    }
    public void testLoading1() throws Exception {
        Model model3=m_modelContext.getModelPhysical(MODEL3_PHYSICAL);
        assertTrue(m_modelContext.isModelLoadedPhysical(MODEL1_PHYSICAL));
        assertTrue(m_modelContext.isModelLoadedPhysical(MODEL2_PHYSICAL));
        assertTrue(m_modelContext.isModelLoadedPhysical(MODEL3_PHYSICAL));
        Model model2=m_modelContext.getModelPhysical(MODEL2_PHYSICAL);
        Model model1=m_modelContext.getModelPhysical(MODEL1_PHYSICAL);

        assertEquals(2,model3.getAllIncludedModels().size());
        assertTrue(model3.getAllIncludedModels().contains(model2));
        assertTrue(model3.getAllIncludedModels().contains(model1));

        assertEquals(1,model2.getAllIncludedModels().size());
        assertTrue(model2.getAllIncludedModels().contains(model1));

        assertEquals(0,model1.getAllIncludedModels().size());

        assertContains(model3,"test:obj1","test:value","Value Obj1",true);
        assertContains(model3,"test:obj2","test:value","Value Obj2",true);
        assertContains(model3,"test:obj3","test:value","Value Obj3",true);
    }
    public void testLoading2() throws Exception {
        Model model1=m_modelContext.getModelPhysical(MODEL1_PHYSICAL);
        Model model3=m_modelContext.getModelPhysical(MODEL3_PHYSICAL);
        Model model2=m_modelContext.getModelPhysical(MODEL2_PHYSICAL);

        assertEquals(2,model3.getAllIncludedModels().size());
        assertTrue(model3.getAllIncludedModels().contains(model2));
        assertTrue(model3.getAllIncludedModels().contains(model1));

        assertEquals(1,model2.getAllIncludedModels().size());
        assertTrue(model2.getAllIncludedModels().contains(model1));

        assertEquals(0,model1.getAllIncludedModels().size());

        assertContains(model3,"test:obj1","test:value","Value Obj1",true);
        assertContains(model3,"test:obj2","test:value","Value Obj2",true);
        assertContains(model3,"test:obj3","test:value","Value Obj3",true);
    }
    public void testLoading3() throws Exception {
        Model model1=m_modelContext.getModelPhysical(MODEL1_PHYSICAL);
        Model model3=m_modelContext.getModelPhysical(MODEL3_PHYSICAL);
        Model model2=m_modelContext.getModelPhysical(MODEL2_PHYSICAL);

        assertSame(model1,m_modelContext.getModelLogical("http://test.org/model1.xml"));
        assertSame(model2,m_modelContext.getModelLogical("http://test.org/model2.xml"));
    }
    public void testLoading4() throws Exception {
        Model model1=m_modelContext.getModelLogical("http://test.org/model1.xml");
        assertEquals(1,model1.size());
        assertContains(model1,"test:obj1","test:value","Value Obj1",true);
    }
    public void testCycles() throws Exception {
        Model model=m_modelContext.getModelPhysical(CYCLE1_PHYSICAL);
        assertTrue(m_modelContext.isModelLoadedPhysical(CYCLE1_PHYSICAL));
        assertTrue(m_modelContext.isModelLoadedPhysical(CYCLE2_PHYSICAL));
        assertTrue(m_modelContext.isModelLoadedPhysical(MODEL1_PHYSICAL));
        assertTrue(m_modelContext.isModelLoadedPhysical(MODEL2_PHYSICAL));
        assertEquals(4,model.size());
        assertContains(model,"test:obj1","test:value","Value Obj1",true);
        assertContains(model,"test:obj2","test:value","Value Obj2",true);
        assertContains(model,"test:cycle1","test:value","Value Cycle1",true);
        assertContains(model,"test:cycle2","test:value","Value Cycle2",true);
    }
}
