package edu.unika.aifb.rdf.mainmemory;

import edu.unika.aifb.rdf.api.model.*;

public class StatementImpl implements Statement {
    protected Resource m_subject;
    protected Resource m_predicate;
    protected RDFNode m_object;
    protected int m_hashCode;

    public StatementImpl(Resource subject,Resource predicate,RDFNode object) {
        m_subject=subject;
        m_predicate=predicate;
        m_object=object;
        m_hashCode=((subject.hashCode()*7)+predicate.hashCode())*7+object.hashCode();
    }
    protected StatementImpl(Resource subject,Resource predicate,RDFNode object,int hashCode) {
        m_subject=subject;
        m_predicate=predicate;
        m_object=object;
        m_hashCode=hashCode;
    }
    public Resource subject() {
        return m_subject;
    }
    public Resource predicate() {
        return m_predicate;
    }
    public RDFNode object() {
        return m_object;
    }
    public String toString() {
        return "triple("+m_subject.toString()+", "+m_predicate.toString()+", "+(m_object instanceof Literal ? "'"+m_object.toString()+"'" : m_object.toString())+")";
    }
    public int hashCode() {
        return m_hashCode;
    }
    public boolean match(Resource subject,Resource predicate,RDFNode object) {
        if (subject!=null && !m_subject.equals(subject))
            return false;
        if (predicate!=null && !m_predicate.equals(predicate))
            return false;
        if (object!=null && !m_object.equals(object))
            return false;
        return true;
    }
    public boolean equals(Object that) {
        if (this==that)
            return true;
        if (!(that instanceof Statement))
            return false;
        try {
            Statement statement=(Statement)that;
            return (m_subject.equals(statement.subject()) && m_predicate.equals(statement.predicate()) && m_object.equals(statement.object()));
        }
        catch (ModelException e) {
            return false;
        }
    }
}
