package edu.unika.aifb.rdf.mainmemory;

import java.util.Map;
import java.util.Set;
import java.util.HashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Collections;

import edu.unika.aifb.rdf.api.model.*;

/**
 * An optimized implementation of Model interface that stores the search results. This model doesn't support model inclusion,
 * transactions etc.
 */
public class SearchResultsModelImpl implements Model {
    protected NodeFactory m_nodeFactory;
    protected Set m_triples;

    public SearchResultsModelImpl(NodeFactory nodeFactory) {
        m_nodeFactory=nodeFactory;
        m_triples=new HashSet();
    }
    public boolean isPersistent() {
        return true;
    }
    public int getInclusionIndex() {
        return 0;
    }
    public Collection getIncludedModels() {
        return Collections.EMPTY_LIST;
    }
    public void addIncludedModel(Model model) throws ModelException {
        throw new ModelException("This operation is not supported for SearchResultsModelImpl implementation.");
    }
    public void removeIncludedModel(Model model) throws ModelException {
        throw new ModelException("This operation is not supported for SearchResultsModelImpl implementation.");
    }
    public Collection getAllIncludedModels() {
        return Collections.EMPTY_LIST;
    }
    public int size() {
        return m_triples.size();
    }
    public boolean isEmpty() {
        return m_triples.isEmpty();
    }
    public Iterator iterator() {
        return m_triples.iterator();
    }
    public boolean contains(Statement statement) {
        return m_triples.contains(statement);
    }
    public boolean contains(Resource subject,Resource predicate,RDFNode object) throws ModelException {
        return thisContains(subject,predicate,object);
    }
    public Model findModel(Statement statement) {
        if (m_triples.contains(statement))
            return this;
        return null;
    }
    public Model find(Resource subject,Resource predicate,RDFNode object) throws ModelException {
        SearchResultsModelImpl result=new SearchResultsModelImpl(m_nodeFactory);
        find(subject,predicate,object,result);
        return result;
    }
    public void find(Resource subject,Resource predicate,RDFNode object,Model result) throws ModelException {
        thisFind(subject,predicate,object,result);
    }
    public String getLogicalURI() {
        return "internal:search-results-model";
    }
    public void setLogicalURI(String logicalURI) throws ModelException {
        throw new ModelException("This operation is not supported for SearchResultsModelImpl implementation.");
    }
    public String getPhysicalURI() {
        return "internal:search-results-model";
    }
    public void setPhysicalURI(String physicalURI) throws ModelException {
        throw new ModelException("This operation is not supported for SearchResultsModelImpl implementation.");
    }
    public void add(Resource subject,Resource predicate,String object) throws ModelException {
        add(subject,predicate,m_nodeFactory.createLiteral(object));
    }
    public void add(Resource subject,Resource predicate,RDFNode object) throws ModelException {
        add(m_nodeFactory.createStatement(subject,predicate,object));
    }
    public void add(Statement statement) throws ModelException {
        if (!m_triples.add(statement))
            throw new ModelException("Statement "+statement.toString()+"is already in model.");
    }
    public void remove(Statement statement) throws ModelException {
        if (!m_triples.remove(statement))
            throw new ModelException("Statement "+statement.toString()+" is not in the model.");
    }
    public String getUniqueResourceURI(String prefix) throws ModelException {
        int counter=1;
        while (true) {
            String uri=prefix+counter;
            Resource resource=m_nodeFactory.createResource(uri);
            if (find(resource,null,null).size()==0 && find(null,resource,null).size()==0 && find(null,null,resource).size()==0)
                return uri;
            counter++;
        }
    }
    public NodeFactory getNodeFactory() {
        return m_nodeFactory;
    }
    public String getLabel() {
        return getURI();
    }
    public boolean supportsTransactions() {
        return false;
    }
    public void setAutocommit(boolean autocommit) throws ModelException {
        if (!autocommit)
            throw new ModelException("Non-autocommit mode is not supproted by this model.");
    }
    public boolean isAutocommit() {
        return true;
    }
    public void commit() throws ModelException {
        throw new ModelException("Transactions are not supproted by this model.");
    }
    public void rollback() throws ModelException {
        throw new ModelException("Transactions are not supproted by this model.");
    }
    public String getURI() {
        return getLogicalURI();
    }
    public String toString() {
        return "Model["+getURI()+" of size "+size()+"]";
    }
    public int thisSize() {
        return m_triples.size();
    }
    public boolean thisIsEmpty() {
        return m_triples.isEmpty();
    }
    public Iterator thisIterator() {
        return m_triples.iterator();
    }
    public boolean thisContains(Statement statement) {
        return m_triples.contains(statement);
    }
    public boolean thisContains(Resource subject,Resource predicate,RDFNode object) throws ModelException {
        if  (thisIsEmpty())
            return false;
        if (subject==null && predicate==null && object==null)
            return !m_triples.isEmpty();
        Iterator iterator=m_triples.iterator();
        while (iterator.hasNext()) {
            Statement statement=(Statement)iterator.next();
            if (statement.match(subject,predicate,object))
                return true;
        }
        return false;
    }
    public Model thisFind(Resource subject,Resource predicate,RDFNode object) throws ModelException {
        SearchResultsModelImpl result=new SearchResultsModelImpl(m_nodeFactory);
        thisFind(subject,predicate,object,result);
        return result;
    }
    public void thisFind(Resource subject,Resource predicate,RDFNode object,Model result) throws ModelException {
        if  (!thisIsEmpty()) {
            Iterator iterator=m_triples.iterator();
            while (iterator.hasNext()) {
                Statement statement=(Statement)iterator.next();
                if (statement.match(subject,predicate,object))
                    result.add(statement);
            }
        }
    }
    public String getAttribute(String key) {
        return null;
    }
    public void setAttribute(String key,String value) throws ModelException {
        throw new ModelException("Cannot set an attribute in the model that is the result of a search.");
    }
    public Map getAttributes() {
        return Collections.EMPTY_MAP;
    }
}
