package edu.unika.aifb.rdf.mainmemory;

import java.util.Map;

import edu.unika.aifb.rdf.api.model.*;
import edu.unika.aifb.rdf.api.util.*;

public class NodeFactoryImpl implements NodeFactory {
    protected Map m_resources;
    protected Map m_literals;

    public NodeFactoryImpl() {
        m_resources=new WeakValueHashMap();
        m_literals=new WeakValueHashMap();
    }
    public synchronized Resource createResource(String uri) {
        Resource result=(Resource)m_resources.get(uri);
        if (result==null) {
            result=new ResourceImpl(uri);
            m_resources.put(uri,result);
        }
        return result;
    }
    public synchronized Resource createResource(String namespace,String localName) {
        String uri=namespace==null ? localName : namespace+localName;
        return createResource(uri);
    }
    public synchronized Literal createLiteral(String str) {
        Literal result=(Literal)m_literals.get(str);
        if (result==null) {
            result=new LiteralImpl(str);
            m_literals.put(str,result);
        }
        return result;
    }
    public synchronized Literal createLiteral(String str,String parseType,String language) {
        if ((parseType==null || RDFConstants.PARSE_TYPE_LITERAL.equals(parseType)) && language==null)
            return createLiteral(str);
        else {
            String key=str+"!"+parseType+"!"+language;
            Literal result=(Literal)m_literals.get(key);
            if (result==null) {
                result=new CompleteLiteralImpl(str,parseType,language);
                m_literals.put(key,result);
            }
            return result;
        }
    }
    public Statement createStatement(Resource subject,Resource predicate,RDFNode object) {
        return new StatementImpl(subject,predicate,object);
    }

}
