package edu.unika.aifb.rdf.mainmemory;

import java.util.Map;
import java.util.HashMap;
import java.util.Collections;
import java.util.Iterator;

import edu.unika.aifb.rdf.api.model.*;

public class ModelImpl extends AbstractModel {
    protected String m_logicalURI;
    protected String m_physicalURI;
    protected FindIndex m_findIndex;
    protected Map m_parameters;
    protected int m_size;

    public ModelImpl(NodeFactory nodeFactory) {
        super(nodeFactory);
        m_parameters=new HashMap();
        m_findIndex=new FindIndex();
    }
    public boolean isPersistent() {
        return false;
    }
    public String getLogicalURI() {
        return m_logicalURI;
    }
    public void setLogicalURI(String logicalURI) {
        m_logicalURI=logicalURI;
    }
    public String getPhysicalURI() {
        return m_physicalURI;
    }
    public void setPhysicalURI(String physicalURI) {
        m_physicalURI=physicalURI;
    }
    public void add(Resource subject,Resource predicate,String object) throws ModelException {
        add(subject,predicate,m_nodeFactory.createLiteral(object));
    }
    public void add(Resource subject,Resource predicate,RDFNode object) throws ModelException {
        add(m_nodeFactory.createStatement(subject,predicate,object));
    }
    public void add(Statement statement) throws ModelException {
        if (contains(statement))
            throw new StatementAlreadyExists(statement);
        m_findIndex.addLookup(statement);
        m_size++;
    }
    public void remove(Statement statement) throws ModelException {
        if (!contains(statement))
            throw new StatementDoesntExist(statement);
        m_findIndex.removeLookup(statement);
        m_size--;
    }
    public String getUniqueResourceURI(String prefix) throws ModelException {
        int counter=1;
        while (true) {
            String uri=prefix+counter;
            Resource resource=m_nodeFactory.createResource(uri);
            if (find(resource,null,null).size()==0 && find(null,resource,null).size()==0 && find(null,null,resource).size()==0)
                return uri;
            counter++;
        }
    }
    public String getLabel() {
        return getURI();
    }
    public boolean supportsTransactions() {
        return false;
    }
    public void setAutocommit(boolean autocommit) throws ModelException {
        if (!autocommit)
            throw new ModelException("Non-autocommit mode is not supproted by this model.");
    }
    public boolean isAutocommit() {
        return true;
    }
    public void commit() throws ModelException {
        throw new ModelException("Transactions are not supproted by this model.");
    }
    public void rollback() throws ModelException {
        throw new ModelException("Transactions are not supproted by this model.");
    }
    public String getURI() {
        return m_logicalURI;
    }
    public String toString() {
        try {
            return "Model["+getURI()+" of size "+size()+"]";
        }
        catch (ModelException e) {
            return "Error";
        }
    }
    public int thisSize() {
        return m_size;
    }
    public boolean thisIsEmpty() {
        return m_size==0;
    }
    public Iterator thisIterator() throws ModelException {
        return m_findIndex.multiget(null,null,null);
    }
    public boolean thisContains(Statement statement) throws ModelException {
        return m_findIndex.contains(statement.subject(),statement.predicate(),statement.object());
    }
    public boolean thisContains(Resource subject,Resource predicate,RDFNode object) throws ModelException {
        if  (thisIsEmpty())
            return false;
        if (subject==null && predicate==null && object==null)
            return !thisIsEmpty();
        return m_findIndex.contains(subject,predicate,object);
    }
    public void thisFind(Resource subject,Resource predicate,RDFNode object,Model result) throws ModelException {
        if  (thisIsEmpty())
            return;
        Iterator iterator=m_findIndex.multiget(subject,predicate,object);
        while (iterator.hasNext()) {
            Statement statement=(Statement)iterator.next();
            if (statement.match(subject,predicate,object))
                result.add(statement);
        }
    }
    public String getAttribute(String key) {
        return (String)m_parameters.get(key);
    }
    public void setAttribute(String key,String value) {
        if (value==null)
            m_parameters.remove(key);
        else
            m_parameters.put(key,value);
    }
    public Map getAttributes() {
        return Collections.unmodifiableMap(m_parameters);
    }
}
