package edu.unika.aifb.rdf.mainmemory;

import edu.unika.aifb.rdf.api.model.*;

public class LiteralImpl extends RDFNodeImpl implements Literal {
    protected String m_label;

    public LiteralImpl(String label) {
        m_label=label;
    }
    public String getURI() {
        return m_label;
    }
    public String getLabel() {
        return m_label;
    }
    public String getDatatype() {
        return null;
    }
    public String getLanguage() {
        return null;
    }
    public int hashCode() {
        return m_label.hashCode();
    }
    public boolean equals(Object that) {
        if (this==that)
            return true;
        if (!(that instanceof Literal))
            return false;
        if (hashCode()!=that.hashCode())
            return false;
        Literal thatLiteral=(Literal)that;
        try {
            return stringsEqual(getLabel(),thatLiteral.getLabel()) && stringsEqual(getLanguage(),thatLiteral.getLanguage()) && stringsEqual(getDatatype(),thatLiteral.getDatatype());
        } catch (ModelException e) {
            return false;
        }
    }
    protected boolean stringsEqual(String s1,String s2) {
        if (s1==null)
            return s2==null;
        else
            return s1.equals(s2);

    }
}
