package edu.unika.aifb.rdf.mainmemory;

import java.util.Set;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

import edu.unika.aifb.rdf.api.model.*;

public class FindIndex {
    protected static final ResourceImpl MAX_RES=new ResourceImpl("<MAX>");
    protected static final Comparator s_spoComparator=new SPOComparator();
    protected static final Comparator s_opComparator=new OPComparator();
    protected static final Comparator s_pComparator=new PComparator();

    protected SortedMap m_spoIndex;
    protected SortedMap m_opIndex;
    protected SortedMap m_pIndex;

    public FindIndex() {
        m_spoIndex=new TreeMap(s_spoComparator);
        m_opIndex=new TreeMap(s_opComparator);
        m_pIndex=new TreeMap(s_pComparator);
    }
    protected void put(Map map,Statement statement) {
        Object object=map.get(statement);
        if (object==null)
            map.put(statement,statement);
        else if (object instanceof Statement) {
            Set set=new HashSet();
            set.add(object);
            set.add(statement);
            map.put(statement,set);
        }
        else
            ((Set)object).add(statement);
    }
    protected void remove(Map map,Statement statement) {
        Object object=map.get(statement);
        if (object==null)
            return;
        else if (object instanceof Statement)
            map.remove(statement);
        else {
            Set set=(Set)object;
            set.remove(statement);
            if (set.size()==0)
                map.remove(statement);
        }
    }
    public void addLookup(Statement statement) {
        put(m_spoIndex,statement);
        put(m_opIndex,statement);
        put(m_pIndex,statement);
    }
    public void removeLookup(Statement statement) {
        remove(m_spoIndex,statement);
        remove(m_opIndex,statement);
        remove(m_pIndex,statement);
    }
    public Iterator multiget(Resource subject,Resource predicate,RDFNode object) throws ModelException {
        StatementImpl dummy=new StatementImpl(subject,predicate,object,Integer.MIN_VALUE);
        if (subject==null) {
            if (object==null)
                return new PrefixIterator(m_pIndex,dummy);
            else
                return new PrefixIterator(m_opIndex,dummy);
        }
        else
            return new PrefixIterator(m_spoIndex,dummy);
    }
    public boolean contains(Resource subject,Resource predicate,RDFNode object) throws ModelException {
        SortedMap sortedMap;
        if (subject==null) {
            if (object==null)
                sortedMap=m_pIndex;
            else
                sortedMap=m_opIndex;
        }
        else
            sortedMap=m_spoIndex;
        StatementImpl dummy=new StatementImpl(subject,predicate,object,Integer.MIN_VALUE);
        SortedMap tailMap=sortedMap.tailMap(dummy);
        if (tailMap.isEmpty())
            return false;
        else {
            Statement statement=(Statement)tailMap.firstKey();
            return statement.match(subject,predicate,object);
        }
    }

    protected static abstract class AbstractComparator implements Comparator {
        protected int compareNodes(RDFNode n1,RDFNode n2) {
            if (n1==n2)
                return 0;
            else if (n1==null || n2==MAX_RES)
                return -1;
            else if (n2==null || n1==MAX_RES)
                return 1;
            else {
                int c1=n1.hashCode();
                int c2=n2.hashCode();
            	if (c1<c2)
                    return -1;
                else if (c1>c2)
                    return 1;
                else
                    try {
                        return n1.getLabel().compareTo(n2.getLabel());
                    }
                    catch (ModelException ignored) {
                        return 0;
                    }
            }
        }
    }

    protected static class SPOComparator extends AbstractComparator  {
        public int compare(Object o1,Object o2) {
            Statement st1=(Statement)o1;
            Statement st2=(Statement)o2;
            try {
                RDFNode n1=st1.subject();
                RDFNode n2=st2.subject();
                int diff=compareNodes(n1,n2);
                if (diff==0) {
                    n1=st1.predicate();
                    n2=st2.predicate();
                    diff=compareNodes(n1,n2);
                    if (diff==0)
                        diff=compareNodes(st1.object(),st2.object());
                }
                return diff;
            }
            catch (ModelException e) {
                return 0;
            }
        }
    }

  protected static class OPComparator extends AbstractComparator  {
        public int compare(Object o1, Object o2) {
            Statement st1=(Statement)o1;
            Statement st2=(Statement)o2;
            try {
            	RDFNode n1=st1.object();
                RDFNode n2=st2.object();
                int diff=compareNodes(n1,n2);
            	if (diff==0) {
            	    n1=st1.predicate();
                	n2=st2.predicate();
                    diff=compareNodes(n1,n2);
                	if (diff==0) {
                        // need this since upper boundary in subMap is not inclusive
                    	if (st2.subject()==MAX_RES)
                            diff=-1;
                    	else if (st1.subject()==MAX_RES)
                            diff=1;
                    	else
                            diff=0;
                    }
                }
                return diff;
            }
            catch (ModelException e) {
                return 0;
            }
        }
    }

    protected static class PComparator extends AbstractComparator  {
        public int compare(Object o1,Object o2) {
            Statement st1=(Statement)o1;
            Statement st2=(Statement)o2;
            try {
                RDFNode n1=st1.predicate();
                RDFNode n2=st2.predicate();
                int diff=compareNodes(n1,n2);
                if (diff==0) {
                    // need this since upper boundary in subMap is not inclusive
                    // either subject or object is OK
                    if (st2.subject()==MAX_RES)
                        diff=-1;
                    else if (st1.subject()==MAX_RES)
                        diff=1;
                    else
                        diff=0;
                }
                return diff;
            }
            catch (ModelException e) {
                return 0;
            }
        }
    }

    protected static class PrefixIterator implements Iterator {
        protected Iterator m_outer;
        protected Object m_current;
        protected Iterator m_inner;

        public PrefixIterator(SortedMap map,Statement statement) throws ModelException {
            if (statement.subject()!=null && statement.predicate()!=null && statement.object()!=null) {
                Object object=map.get(statement);
                Set singleValue=new HashSet();
                singleValue.add(object);
                m_outer=singleValue.iterator();
            }
            else {
            	Statement limit=new StatementImpl(limitResource(statement.subject()),limitResource(statement.predicate()),limitNode(statement.object()));
                SortedMap subMap=map.subMap(statement,limit);
                m_outer=subMap.values().iterator();
            }
            step();
        }
        protected Resource limitResource(Resource resource) {
            return resource==null ? MAX_RES : resource;
        }
        protected RDFNode limitNode(RDFNode node) {
            return node==null ? MAX_RES : node;
        }
        protected void step() {
            m_current=null;
            if (m_inner==null || !m_inner.hasNext()) {
                m_inner=null;
                if (m_outer.hasNext()) {
                    Object object=m_outer.next();
                    if (object instanceof Statement)
                        m_current=object;
                    else if (object instanceof Set) {
	                    m_inner=((Set)object).iterator();
	                    m_current=m_inner.next();
                    }
                }
            }
            else
                m_current=m_inner.next();
        }
        public boolean hasNext() {
            return m_current!=null;
        }
        public Object next() {
            if (m_current==null)
            	throw new NoSuchElementException();
            Object saved=m_current;
            step();
            return saved;
        }
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}
