package edu.unika.aifb.rdf.mainmemory;

public class CompleteLiteralImpl extends LiteralImpl {
    protected String m_datatype;
    protected String m_language;
    protected int m_hashCode;

    public CompleteLiteralImpl(String label,String datatype,String language) {
        super(label);
        m_datatype=datatype;
        m_language=language;
        if (m_datatype==null && m_language==null)
            m_hashCode=m_label.hashCode();
        else
            m_hashCode=(m_label.hashCode()*7+(m_datatype==null ? 0 : m_datatype.hashCode()))*7+(m_language==null ? 0 : m_language.hashCode());
    }
    public String getDatatype() {
        return m_datatype;
    }
    public String getLanguage() {
        return m_language;
    }
    public int hashCode() {
        return m_hashCode;
    }
    public String toString() {
        return m_label+(m_datatype!=null ? "/"+m_datatype : "")+(m_language!=null ? "/"+m_language : "");
    }
}
