package edu.unika.aifb.rdf.api.util;

import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;

import edu.unika.aifb.rdf.api.model.*;

/**
 * An implementation of set operations on models.
 * Every of these static methods first attempts to use the native implementation provided by the model if any.
 */

public class SetOperations {

    public static void copy(Model src,Model dest) throws ModelException {
        subtract(dest,dest);
        unite(dest,src);
    }
    public static void unite(Model m1,Model m2) throws ModelException {
        NodeFactory nodeFactory=m1.getNodeFactory();
        for (Iterator i=m2.iterator();i.hasNext();) {
            Statement statement=(Statement)i.next();
            Resource subject=nodeFactory.createResource(statement.subject().getURI());
            Resource predicate=nodeFactory.createResource(statement.predicate().getURI());
            RDFNode object=statement.object();
            if (object instanceof Resource)
                object=nodeFactory.createResource(((Resource)object).getURI());
            else
                object=nodeFactory.createLiteral(object.getLabel());
            statement=nodeFactory.createStatement(subject,predicate,object);
            if (!m1.contains(statement))
                m1.add(statement);
        }
    }

    public static void subtract(Model m1,Model m2) throws ModelException {
        for (Iterator i=m2.iterator();i.hasNext();) {
            Statement statement=(Statement)i.next();
            if (m1.contains(statement))
                m1.remove(statement);
        }
    }
    public static void intersect(Model m1,Model m2) throws ModelException {
        Set set=new HashSet();
        Iterator iterator=m1.iterator();
        while (iterator.hasNext())
            set.add(iterator.next());
        for (Iterator i=set.iterator();i.hasNext();) {
            Statement t=(Statement)i.next();
            if (!m2.contains(t))
                m1.remove(t);
        }
    }
    public static Model union(Model m1,Model m2,Model result) throws ModelException {
        subtract(result,result);
        unite(result,m1);
        unite(result,m2);
        return result;
    }
    public static Model difference(Model m1,Model m2,Model result) throws ModelException {
        subtract(result,result);
        unite(result,m1);
        subtract(result,m2);
        return result;
    }
    public static Model intersection(Model m1,Model m2,Model result) throws ModelException {
        subtract(result,result);
        NodeFactory nodeFactory=result.getNodeFactory();
        Iterator iterator=m1.iterator();
        while (iterator.hasNext()) {
            Statement statement=(Statement)iterator.next();
            if (m2.contains(statement)) {
                Resource subject=nodeFactory.createResource(statement.subject().getURI());
                Resource predicate=nodeFactory.createResource(statement.predicate().getURI());
                RDFNode object=statement.object();
                if (object instanceof Resource)
                    object=nodeFactory.createResource(((Resource)object).getURI());
                else
                    object=nodeFactory.createLiteral(object.getLabel());
                statement=nodeFactory.createStatement(subject,predicate,object);
                result.add(statement);
            }
        }
        return result;
    }
}