package edu.unika.aifb.rdf.api.util;

import edu.unika.aifb.rdf.api.model.Model;
import edu.unika.aifb.rdf.api.model.NodeFactory;
import edu.unika.aifb.rdf.api.model.ModelException;

/**
 * An implementation of this class exists per single implementation of RDF. It is used to
 * manage models of that implementation.
 */
public interface RDFFactory {
    /**
     * Create an empty model. If this factory cannot service this URI, <code>null</code> should be returned.
     *
     * @param physicalURI   physical URI of the model
     * @param nodeFactory   the node factory for the new model (may be <code>null</code>)
     * @return              new model or <code>null</code> if model with given URI cannot be created by this implementation
     */
    Model createModel(String physicalURI,NodeFactory nodeFactory) throws ModelException;
    /**
     * Opens an existing model. If this factory cannot service this URI, <code>null</code> should be returned.
     *
     * @param physicalURI   physical URI of the model
     * @param nodeFactory   the node factory for the new model (may be <code>null</code>)
     * @return              model information or <code>null</code> if model with given URI cannot be created by this implementation
     */
    RDFManager.ModelInfo openModelEx(String physicalURI,NodeFactory nodeFactory) throws ModelException;
    /**
     * Deletes an existing model. If this factory cannot service this URI, <code>false</code> should be returned.
     *
     * @param physicalURI   physical URI of the model
     * @return              <code>true</code> if this factory could delete the model
     */
    boolean deleteModel(String physicalURI) throws ModelException;
}
