package edu.unika.aifb.rdf.api.util;

import edu.unika.aifb.rdf.api.model.ModelException;

/**
 * Thrown if RDF factory for some URI cannot be found.
 */
public class NoRDFFactoryException extends ModelException {
    /**
     * Creates an instance of this class.
     */
    public NoRDFFactoryException() {
        super("RDF factory not found");
    }
    /**
     * Creates an instance of this class.
     *
     * @param message                   cause of failure
     * @param cause                     original exception
     */
    public NoRDFFactoryException(String message,Throwable cause) {
        super(message,cause);
    }
}
