package edu.unika.aifb.rdf.api.util;

import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;

import edu.unika.aifb.rdf.api.model.Model;
import edu.unika.aifb.rdf.api.model.ModelException;

public class ModelContext {
    protected Map m_logicalToPhysicalURI;
    protected Map m_physicalURItoModel;
    protected Map m_logicalURItoModel;

    public ModelContext() {
        m_logicalToPhysicalURI=new HashMap();
        m_physicalURItoModel=new HashMap();
        m_logicalURItoModel=new HashMap();
    }
    public synchronized void mapLogicalToPhysicalURI(String logicalURI,String physicalURI) {
        m_logicalToPhysicalURI.put(logicalURI,physicalURI);
    }
    public synchronized void unmapLogicalURI(String logicalURI) {
        m_logicalToPhysicalURI.remove(logicalURI);
    }
    public synchronized String getPhysicalFromLogicalURI(String logicalURI) {
        return (String)m_logicalToPhysicalURI.get(logicalURI);
    }
    public synchronized void registerModel(Model model) throws ModelException {
        registerModelInternal(model);
        Iterator models=model.getAllIncludedModels().iterator();
        while (models.hasNext()) {
            Model includedModel=(Model)models.next();
            registerModelInternal(includedModel);
        }
    }
    protected void registerModelInternal(Model model) throws ModelException {
        m_physicalURItoModel.put(model.getPhysicalURI(),model);
        m_logicalURItoModel.put(model.getLogicalURI(),model);
    }
    public synchronized Model getModelPhysical(String physicalURI) throws ModelException {
        Model model=(Model)m_physicalURItoModel.get(physicalURI);
        if (model==null) {
            RDFManager.ModelInfo modelInfo=RDFManager.openModelEx(physicalURI,null);
            model=modelInfo.m_model;
            registerModelInternal(model);
            for (int i=0;i<modelInfo.m_includedModels.length;i++) {
                Model includedModel=null;
                String includedLogicalURI=modelInfo.m_includedModels[i][0];
                if (includedLogicalURI!=null) {
                    includedModel=(Model)m_logicalURItoModel.get(includedLogicalURI);
                    if (includedModel==null) {
                        String resolvedPhysicalURI=getPhysicalFromLogicalURI(includedLogicalURI);
                        if (resolvedPhysicalURI!=null)
                            includedModel=getModelPhysical(resolvedPhysicalURI);
                    }
                }
                if (includedModel==null) {
                    String includedPhysicalURI=modelInfo.m_includedModels[i][1];
                    if (includedPhysicalURI==null)
                        throw new ModelException("The logical to physical URI mapping for model '"+modelInfo.m_includedModels[i][0]+"'doesn't exist, so physical URI should be specified");
                    includedModel=getModelPhysical(includedPhysicalURI);
                }
                model.addIncludedModel(includedModel);
            }
        }
        return model;
    }
    public synchronized Model getModelLogical(String logicalURI) throws ModelException {
        Model model=(Model)m_logicalURItoModel.get(logicalURI);
        if (model==null) {
            String physicalURI=getPhysicalFromLogicalURI(logicalURI);
            if (physicalURI==null)
                throw new ModelException("Cannot map logical URI '"+logicalURI+"' to physical URI.");
            model=getModelPhysical(physicalURI);
        }
        return model;
    }
    public synchronized void removeModel(Model model) throws ModelException {
        m_physicalURItoModel.remove(model.getPhysicalURI());
        m_logicalURItoModel.remove(model.getLogicalURI());
    }
    public synchronized boolean isModelLoadedPhysical(String physicalURI) {
        return m_physicalURItoModel.containsKey(physicalURI);
    }
    public synchronized boolean isModelLoadedLogical(String logicalURI) {
        return m_logicalURItoModel.containsKey(logicalURI);
    }
}
