package edu.unika.aifb.rdf.api.model;

/**
 * An exception thrown if a statement doesn't exist.
 */
public class StatementDoesntExist extends ModelWarning {
    /** The statement. */
    protected Statement m_statement;

    /**
     * Creates an instance of this class.
     *
     * @param statement                     the statement that doesn't exist
     */
    public StatementDoesntExist(Statement statement) {
        super("Statement "+getStatementText(statement)+" doesn't exist.");
        m_statement=statement;
    }
}
