package edu.unika.aifb.rdf.api.model;

/**
 * An exception thrown if a statement already exists in the model.
 */
public class StatementAlreadyExists extends ModelWarning {
    /** The statement. */
    protected Statement m_statement;

    /**
     * Creates an instance of this class.
     *
     * @param statement                     the statement that doesn't exist
     */
    public StatementAlreadyExists(Statement statement) {
        super("Statement "+getStatementText(statement)+" already exist in the model.");
        m_statement=statement;
    }
}
