package edu.unika.aifb.rdf.api.model;

/**
 * An RDF statement. Statements must implement <code>getURI()</code> according to a standard MD5-based algorithm.
 */
public interface Statement {
    /**
     * @return subject of the triple
     */
    Resource subject() throws ModelException;
    /**
     * @return predicate of the triple
     */
    Resource predicate() throws ModelException;
    /**
     * @return object of the triple
     */
    RDFNode object() throws ModelException;
    /**
     * Checks whether this statement matches given parameters. Each of the parameters may be <code>null</code>, meaning
     * that any statemnet value is accepted.
     */
    boolean match(Resource subject,Resource predicate,RDFNode object) throws ModelException;
}
