package edu.unika.aifb.rdf.api.model;

/**
 * An RDF resource. Every RDF resource must have a URI.  Many RDF
 * resources are pieces of vocabulary. They typically have a namespace
 * and a local name. In this case, a URI is composed as a
 * concatenation of the namespace and the local name.
 * For other kinds of identifiers (e.g. autogenerated UUIDs), the namespace is null.
 */
public interface Resource extends RDFNode {

    /**
     * Returns the URI of the resource. Triples and models must implement this method in a standard way.
     *
     * @return                      the URI of the resource
     */
    public String getURI() throws ModelException;
}
