package edu.unika.aifb.rdf.api.model;

/**
 * Provides methods for creating resources, literals and statements.
 */
public interface NodeFactory {

    /**
     * Creates a resource with a URI.
     */
    public Resource createResource(String uri) throws ModelException;

    /**
     * Creates a resource out of a string
     */
    public Resource createResource(String namespace, String localName) throws ModelException;

    /**
     * Creates a literal from a string
     */
    public Literal createLiteral(String str) throws ModelException;

    /**
     * Creates a literal from a string
     */
    public Literal createLiteral(String str,String datatype,String language) throws ModelException;

    /**
     * Creates a triple
     */
    public Statement createStatement(Resource subject, Resource predicate, RDFNode object) throws ModelException;

}
