package edu.unika.aifb.rdf.api.model;

/**
 * An exception thrown if there is an error with model manipulation.
 */
public class ModelException extends Exception {
    /**
     * Creates an instance of this class.
     *
     * @param message               message specifying the reason for failure
     */
    public ModelException(String message) {
        super(message);
    }
    /**
     * Creates an instance of this class.
     *
     * @param message               message specifying the reason for failure
     * @param cause                 original cause of failure
     */
    public ModelException(String message,Throwable cause) {
        super(message,cause);
    }
    /**
     * Generates the text description of the statement.
     *
     * @param statement                     the statement
     */
    public static String getStatementText(Statement statement) {
        try {
            return "["+statement.subject().getURI()+","+statement.predicate()+","+statement.object().getLabel()+"]";
        }
        catch (ModelException e) {
            return "";
        }
    }
}
