package edu.unika.aifb.kaon.query.compiler;

import java.util.Set;
import java.util.HashSet;

import edu.unika.aifb.kaon.query.ast.*;

/**
 * The that collects the set of property names from the expression.
 */
public class CollectPropertyNamesVisitor implements ExpressionVisitor {
    /** The set of property names. */
    protected Set m_propertyNames;

    /**
     * Creates an instance of this class.
     */
    public CollectPropertyNamesVisitor() {
        m_propertyNames=new HashSet();
    }
    /**
     * Returns the set of property names.
     *
     * @return                                  the set of property names
     */
    public Set getPropertyNames() {
        return m_propertyNames;
    }
    /**
     * Visits the primitive concept.
     *
     * @param expression                        the expression
     */
    public void visit(PrimitiveConcept expression) {
    }
    /**
     * Visits the nominal concept.
     *
     * @param expression                        the expression
     */
    public void visit(NominalConceptExpression expression) {
    }
    /**
     * Visits the concept whose instances are strings defined by a regular expression.
     *
     * @param expression                        the expression
     */
    public void visit(RegExpConceptExpression expression) {
    }
    /**
     * Visits the functional concept expression.
     *
     * @param expression                        the expression
     */
    public void visit(FunctionalConceptExpression expression) {
        expression.getConceptExpression().accept(this);
    }
    /**
     * Visits the ALL restriction.
     *
     * @param expression                        the expression
     */
    public void visit(AllRestriction expression) {
        expression.getConceptExpression().accept(this);
        expression.getPropertyExpression().accept(this);
    }
    /**
     * Visits the SOME restriction.
     *
     * @param expression                        the expression
     */
    public void visit(SomeRestriction expression) {
        expression.getConceptExpression().accept(this);
        expression.getPropertyExpression().accept(this);
    }
    /**
     * Visits the NOT expression.
     *
     * @param expression                        the expression
     */
    public void visit(NotExpression expression) {
        expression.getConceptExpression().accept(this);
    }
    /**
     * Visits the AND expression.
     *
     * @param expression                        the expression
     */
    public void visit(AndExpression expression) {
        expression.getConceptExpression1().accept(this);
        expression.getConceptExpression2().accept(this);
    }
    /**
     * Visits the OR expression.
     *
     * @param expression                        the expression
     */
    public void visit(OrExpression expression) {
        expression.getConceptExpression1().accept(this);
        expression.getConceptExpression2().accept(this);
    }
    /**
     * Visits the property projection.
     *
     * @param expression                        the expression
     */
    public void visit(PropertyProjection expression) {
        expression.getPropertyExpression().accept(this);
    }
    /**
     * Visits the primitive property.
     *
     * @param expression                        the expression
     */
    public void visit(PrimitiveProperty expression) {
        m_propertyNames.add(expression.getPropertyURI());
    }
    /**
     * Visits the functional property expression.
     *
     * @param expression                        the expression
     */
    public void visit(FunctionalPropertyExpression expression) {
        expression.getPropertyExpression().accept(this);
    }
    /**
     * Visits the inverse property.
     *
     * @param expression                        the expression
     */
    public void visit(InverseProperty expression) {
        expression.getPropertyExpression().accept(this);
    }
    /**
     * Visits the path expression.
     *
     * @param expression                        the expression
     */
    public void visit(PathExpression expression) {
        expression.getPropertyExpression1().accept(this);
        expression.getConceptExpression().accept(this);
        expression.getPropertyExpression2().accept(this);
    }
    /**
     * Visits the concept multiplication.
     *
     * @param expression                        the expression
     */
    public void visit(MultiplyExpression expression) {
        expression.getConceptExpression1().accept(this);
        expression.getConceptExpression2().accept(this);
    }
    /**
     * Visits the property selection.
     *
     * @param expression                        the expression
     */
    public void visit(PropertySelection expression) {
        expression.getPropertyExpression().accept(this);
        expression.getConceptExpression().accept(this);
    }
}
