package edu.unika.aifb.kaon.query.ast;

/**
 * The E R.C restriction.
 */
public class SomeRestriction extends ConceptExpression {
    /** The property expression. */
    protected PropertyExpression m_propertyExpression;
    /** The concept expression. */
    protected ConceptExpression m_conceptExpression;

    /**
     * Creates an instance of this class.
     *
     * @param propertyExpression                    the property expression
     * @param conceptExpression                     the concept expression
     */
    public SomeRestriction(PropertyExpression propertyExpression,ConceptExpression conceptExpression) {
        m_propertyExpression=propertyExpression;
        m_conceptExpression=conceptExpression;
    }
    /**
     * Returns the property expression.
     *
     * @return                                      the property expression
     */
    public PropertyExpression getPropertyExpression() {
        return m_propertyExpression;
    }
    /**
     * Returns the concept expression.
     *
     * @return                                      the concept expression
     */
    public ConceptExpression getConceptExpression() {
        return m_conceptExpression;
    }
    /**
     * Accepts a visitor.
     *
     * @param visitor                               the visitor
     */
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}
