package edu.unika.aifb.kaon.query.ast;

/**
 * The concept whose instances are strings defined by given regular expression.
 */
public class RegExpConceptExpression extends ConceptExpression {
    /** The regular expression value. */
    protected String m_regularExpression;

    /**
     * Creates an instance of this class.
     *
     * @param regularExpression                     the regular expression
     */
    public RegExpConceptExpression(String regularExpression) {
        m_regularExpression=regularExpression;
    }
    /**
     * Returns the regular expression.
     *
     * @return                                      the regular expression
     */
    public String getRegularExpression() {
        return m_regularExpression;
    }
    /**
     * Accepts a visitor.
     *
     * @param visitor                               the visitor
     */
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}
