package edu.unika.aifb.kaon.query.ast;

/**
 * The the selection of the property.
 */
public class PropertySelection extends PropertyExpression {
    /** The property expression. */
    protected PropertyExpression m_propertyExpression;
    /** The position which is selected. */
    protected int m_selectionPosition;
    /** The concept expression. */
    protected ConceptExpression m_conceptExpression;

    /**
     * Creates an instance of this class.
     *
     * @param propertyExpression                    the property expression
     * @param selectionPosition                     the position on which the selection is performed
     * @param conceptExpression                     the concept expression
     */
    public PropertySelection(PropertyExpression propertyExpression,int selectionPosition,ConceptExpression conceptExpression) {
        m_propertyExpression=propertyExpression;
        m_selectionPosition=selectionPosition;
        m_conceptExpression=conceptExpression;
    }
    /**
     * Returns the property expression.
     *
     * @return                                      the property expression
     */
    public PropertyExpression getPropertyExpression() {
        return m_propertyExpression;
    }
    /**
     * Returns the position on which the selection is performed.
     *
     * @return                                      the position on which the selection is performed
     */
    public int getSelectionPosition() {
        return m_selectionPosition;
    }
    /**
     * Returns the concept expression.
     *
     * @return                                      the concept expression
     */
    public ConceptExpression getConceptExpression() {
        return m_conceptExpression;
    }
    /**
     * Accepts a visitor.
     *
     * @param visitor                               the visitor
     */
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}
