package edu.unika.aifb.kaon.query.ast;

/**
 * The the projection of the property.
 */
public class PropertyProjection extends ConceptExpression {
    /** The property expression. */
    protected PropertyExpression m_propertyExpression;
    /** The position which is projected. */
    protected int m_projectionPosition;

    /**
     * Creates an instance of this class.
     *
     * @param propertyExpression                    the property expression
     * @param projectionPosition                    the position on which the projection is performed
     */
    public PropertyProjection(PropertyExpression propertyExpression,int projectionPosition) {
        m_propertyExpression=propertyExpression;
        m_projectionPosition=projectionPosition;
    }
    /**
     * Returns the property expression.
     *
     * @return                                      the property expression
     */
    public PropertyExpression getPropertyExpression() {
        return m_propertyExpression;
    }
    /**
     * Returns the position on which the projection is performed.
     *
     * @return                                      the position on which the projection is performed
     */
    public int getProjectionPosition() {
        return m_projectionPosition;
    }
    /**
     * Accepts a visitor.
     *
     * @param visitor                               the visitor
     */
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}
