package edu.unika.aifb.kaon.query.ast;

/**
 * The expression containing the primitive property.
 */
public class PrimitiveProperty extends PropertyExpression {
    /** The URI of the primitive property. */
    protected String m_propertyURI;

    /**
     * Creates an instance of this class.
     *
     * @param propertyURI                       the URI of the primitive property
     */
    public PrimitiveProperty(String propertyURI) {
        m_propertyURI=propertyURI;
    }
    /**
     * Returns the property URI.
     *
     * @return                                  the URI of the property
     */
    public String getPropertyURI() {
        return m_propertyURI;
    }
    /**
     * Accepts a visitor.
     *
     * @param visitor                               the visitor
     */
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}
