package edu.unika.aifb.kaon.query.ast;

/**
 * The expression containing the primitive concept.
 */
public class PrimitiveConcept extends ConceptExpression {
    /** The identified of the ROOT concept. */
    public static final String ROOT="http://kaon.semanticweb.org/2001/11/kaon-lexical#Root";

    /** The URI of the primitive concept. */
    protected String m_conceptURI;

    /**
     * Creates an instance of this class.
     *
     * @param conceptURI                        the URI of the primitive concept
     */
    public PrimitiveConcept(String conceptURI) {
        m_conceptURI=conceptURI;
    }
    /**
     * Creates a primitive concept with the ROOT URI.
     */
    public PrimitiveConcept() {
        this(ROOT);
    }
    /**
     * Returns the concept URI.
     *
     * @return                                  the URI of the concept
     */
    public String getConceptURI() {
        return m_conceptURI;
    }
    /**
     * Accepts a visitor.
     *
     * @param visitor                               the visitor
     */
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}
