package edu.unika.aifb.kaon.query.ast;

/**
 * The property path expression.
 */
public class PathExpression extends PropertyExpression {
    /** The first property expression. */
    protected PropertyExpression m_propertyExpression1;
    /** The concept expression. */
    protected ConceptExpression m_conceptExpression;
    /** The second property expression. */
    protected PropertyExpression m_propertyExpression2;

    /**
     * Creates an instance of this class.
     *
     * @param propertyExpression1               the first property expression
     * @param conceptExpression                 the concept expression
     * @param propertyExpression2               the second property expression
     */
    public PathExpression(PropertyExpression propertyExpression1,ConceptExpression conceptExpression,PropertyExpression propertyExpression2) {
        m_propertyExpression1=propertyExpression1;
        m_conceptExpression=conceptExpression;
        m_propertyExpression2=propertyExpression2;
    }
    /**
     * Creates an instance of this class.
     *
     * @param propertyExpression1               the first property expression
     * @param propertyExpression2               the second property expression
     */
    public PathExpression(PropertyExpression propertyExpression1,PropertyExpression propertyExpression2) {
        this(propertyExpression1,new PrimitiveConcept(),propertyExpression2);
    }
    /**
     * Checks whether the concept expression is a ROOT concept.
     *
     * @return                                  <code>true</code> if the concept expression is a ROOT concept
     */
    public boolean isConceptExpressionRootConcept() {
        if (m_conceptExpression instanceof PrimitiveConcept) {
            PrimitiveConcept primitiveConcept=(PrimitiveConcept)m_conceptExpression;
            return PrimitiveConcept.ROOT.equals(primitiveConcept.getConceptURI());
        }
        else
            return false;
    }
    /**
     * Returns the first property expression.
     *
     * @return                                  the first property expression
     */
    public PropertyExpression getPropertyExpression1() {
        return m_propertyExpression1;
    }
    /**
     * Returns the concept expression.
     *
     * @return                                  the concept expression
     */
    public ConceptExpression getConceptExpression() {
        return m_conceptExpression;
    }
    /**
     * Returns the second property expression.
     *
     * @return                                  the second property expression
     */
    public PropertyExpression getPropertyExpression2() {
        return m_propertyExpression2;
    }
    /**
     * Accepts a visitor.
     *
     * @param visitor                               the visitor
     */
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}
