package edu.unika.aifb.kaon.query.ast;

/**
 * The negation of the concept expression.
 */
public class NotExpression extends ConceptExpression {
    /** The concept expression. */
    protected ConceptExpression m_conceptExpression;

    /**
     * Creates an instance of this class.
     *
     * @param conceptExpression                     the concept expression
     */
    public NotExpression(ConceptExpression conceptExpression) {
        m_conceptExpression=conceptExpression;
    }
    /**
     * Returns the concept expression.
     *
     * @return                                      the concept expression
     */
    public ConceptExpression getConceptExpression() {
        return m_conceptExpression;
    }
    /**
     * Accepts a visitor.
     *
     * @param visitor                               the visitor
     */
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}
