package edu.unika.aifb.kaon.query.ast;

import java.util.Set;
import java.util.HashSet;

/**
 * Represents a concept expression consisting of nominals.
 */
public class NominalConceptExpression extends ConceptExpression {
    /** The set of instance identifiers. */
    protected Set m_instanceIdentifiers;
    /** The set of constants. */
    protected Set m_constants;

    /**
     * Creates an instance of this class.
     */
    public NominalConceptExpression() {
        m_instanceIdentifiers=new HashSet();
        m_constants=new HashSet();
    }
    /**
     * Adds an instance identifier to this expression.
     *
     * @param instanceIdentifier                    the instance identifier
     */
    public void addInstanceIdentifier(String instanceIdentifier) {
        m_instanceIdentifiers.add(instanceIdentifier);
    }
    /**
     * Adds a constant to this expression.
     *
     * @param constant                              the constant
     */
    public void addConstant(Object constant) {
        m_constants.add(constant);
    }
    /**
     * Returns the set of all instance identifiers.
     *
     * @return                                      the set of all instance identifiers
     */
    public Set getInstanceIdentifiers() {
        return m_instanceIdentifiers;
    }
    /**
     * Returns the set of all constants.
     *
     * @return                                      the set of all constants
     */
    public Set getConstants() {
        return m_constants;
    }
    /**
     * Accepts a visitor.
     *
     * @param visitor                               the visitor
     */
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}
