package edu.unika.aifb.kaon.query.ast;

/**
 * The product of two concept expressions.
 */
public class MultiplyExpression extends PropertyExpression {
    /** The first concept expression. */
    protected ConceptExpression m_conceptExpression1;
    /** The second concept expression. */
    protected ConceptExpression m_conceptExpression2;

    /**
     * Creates an instance of this class.
     *
     * @param conceptExpression1                    the first concept expression
     * @param conceptExpression2                    the second concept expression
     */
    public MultiplyExpression(ConceptExpression conceptExpression1,ConceptExpression conceptExpression2) {
        m_conceptExpression1=conceptExpression1;
        m_conceptExpression2=conceptExpression2;
    }
    /**
     * Returns the first concept expression.
     *
     * @return                                      the first concept expression
     */
    public ConceptExpression getConceptExpression1() {
        return m_conceptExpression1;
    }
    /**
     * Returns the second concept expression.
     *
     * @return                                      the second concept expression
     */
    public ConceptExpression getConceptExpression2() {
        return m_conceptExpression2;
    }
    /**
     * Accepts a visitor.
     *
     * @param visitor                               the visitor
     */
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}
