package edu.unika.aifb.kaon.query.ast;

/**
 * The inverse of some property.
 */
public class InverseProperty extends PropertyExpression {
    /** The property expression that this expression is inverse of. */
    protected PropertyExpression m_propertyExpression;

    /**
     * Creates an instance of this class.
     *
     * @param propertyExpression                the property that this expression is inverse of
     */
    public InverseProperty(PropertyExpression propertyExpression) {
        m_propertyExpression=propertyExpression;
    }
    /**
     * Returns the expression that this property is inverse of.
     *
     * @return                                  the expression that this property is inverse of
     */
    public PropertyExpression getPropertyExpression() {
        return m_propertyExpression;
    }
    /**
     * Accepts a visitor.
     *
     * @param visitor                               the visitor
     */
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}
