package edu.unika.aifb.kaon.query.ast;

/**
 * The functional property expression.
 */
public class FunctionalPropertyExpression extends PropertyExpression {
    /** The name of the function applied to the property expression. */
    protected String m_functionName;
    /** The position to which the function is applied. */
    protected int m_applicationPosition;
    /** The property expression. */
    protected PropertyExpression m_propertyExpression;

    /**
     * Creates an instance of this class.
     *
     * @param functionName                          the name of the function
     * @param applicationPosition                   the position to which the function is applied
     * @param propertyExpression                    the property expression
     */
    public FunctionalPropertyExpression(String functionName,int applicationPosition,PropertyExpression propertyExpression) {
        m_functionName=functionName;
        m_applicationPosition=applicationPosition;
        m_propertyExpression=propertyExpression;
    }
    /**
     * Returns the name of the function.
     *
     * @return                                      the name of the function
     */
    public String getFunctionName() {
        return m_functionName;
    }
    /**
     * Returns the position to which the function is applied.
     *
     * @return                                      the position to which the function is applied
     */
    public int getApplicationPosition() {
        return m_applicationPosition;
    }
    /**
     * Returns the property expression.
     *
     * @return                                      the property expression
     */
    public PropertyExpression getPropertyExpression() {
        return m_propertyExpression;
    }
    /**
     * Accepts a visitor.
     *
     * @param visitor                               the visitor
     */
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}
