package edu.unika.aifb.kaon.query.ast;

/**
 * The functional concept expression.
 */
public class FunctionalConceptExpression extends ConceptExpression {
    /** The name of the function applied to the concept expression. */
    protected String m_functionName;
    /** The concept expression. */
    protected ConceptExpression m_conceptExpression;

    /**
     * Creates an instance of this class.
     *
     * @param functionName                          the name of the function
     * @param conceptExpression                     the concept expression
     */
    public FunctionalConceptExpression(String functionName,ConceptExpression conceptExpression) {
        m_functionName=functionName;
        m_conceptExpression=conceptExpression;
    }
    /**
     * Returns the name of the function.
     *
     * @return                                      the name of the function
     */
    public String getFunctionName() {
        return m_functionName;
    }
    /**
     * Returns the concept expression.
     *
     * @return                                      the concept expression
     */
    public ConceptExpression getConceptExpression() {
        return m_conceptExpression;
    }
    /**
     * Accepts a visitor.
     *
     * @param visitor                               the visitor
     */
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}
