package edu.unika.aifb.kaon.query.ast;

/**
 * The visitor interface for the expression.
 */
public interface ExpressionVisitor {
    /**
     * Visits the primitive concept.
     *
     * @param expression                        the expression
     */
    void visit(PrimitiveConcept expression);
    /**
     * Visits the nominal concept.
     *
     * @param expression                        the expression
     */
    void visit(NominalConceptExpression expression);
    /**
     * Visits the concept whose instances are strings defined by a regular expression.
     *
     * @param expression                        the expression
     */
    void visit(RegExpConceptExpression expression);
    /**
     * Visits the functional concept expression.
     *
     * @param expression                        the expression
     */
    void visit(FunctionalConceptExpression expression);
    /**
     * Visits the ALL restriction.
     *
     * @param expression                        the expression
     */
    void visit(AllRestriction expression);
    /**
     * Visits the SOME restriction.
     *
     * @param expression                        the expression
     */
    void visit(SomeRestriction expression);
    /**
     * Visits the NOT expression.
     *
     * @param expression                        the expression
     */
    void visit(NotExpression expression);
    /**
     * Visits the AND expression.
     *
     * @param expression                        the expression
     */
    void visit(AndExpression expression);
    /**
     * Visits the OR expression.
     *
     * @param expression                        the expression
     */
    void visit(OrExpression expression);
    /**
     * Visits the property projection.
     *
     * @param expression                        the expression
     */
    void visit(PropertyProjection expression);
    /**
     * Visits the primitive property.
     *
     * @param expression                        the expression
     */
    void visit(PrimitiveProperty expression);
    /**
     * Visits the functional property expression.
     *
     * @param expression                        the expression
     */
    void visit(FunctionalPropertyExpression expression);
    /**
     * Visits the inverse property.
     *
     * @param expression                        the expression
     */
    void visit(InverseProperty expression);
    /**
     * Visits the path expression.
     *
     * @param expression                        the expression
     */
    void visit(PathExpression expression);
    /**
     * Visits the concept multiplication.
     *
     * @param expression                        the expression
     */
    void visit(MultiplyExpression expression);
    /**
     * Visits the property selection.
     *
     * @param expression                        the expression
     */
    void visit(PropertySelection expression);
}
