package de.fzi.wim.oimodeler.viewfilter;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

/**
 * Filters the elements from the view.
 */
public interface ViewFilter {
    /**
     * Returns <code>true</code> if supplied entity should be shown in the view.
     *
     * @param entity                        the entity being shown
     * @return                              <code>true</code> if the entity should be shown in the view
     * @throws KAONException                thrown if there is an error
     */
    boolean showEntity(Entity entity) throws KAONException;
    /**
     * Returns <code>true</code> if supplied property instance should be shown in the view.
     *
     * @param propertyInstance              the property instance being shown
     * @return                              <code>true</code> if the property instance should be shown in the view
     * @throws KAONException                thrown if there is an error
     */
    boolean showPropertyInstance(PropertyInstance propertyInstance) throws KAONException;
}
