package de.fzi.wim.oimodeler.viewfilter;

import edu.unika.aifb.kaon.api.oimodel.Entity;
import edu.unika.aifb.kaon.api.oimodel.PropertyInstance;

/**
 * Filter that shows all elements from the view.
 */
public class NullViewFilter implements ViewFilter {
    /**
     * Returns <code>true</code> if supplied entity should be shown in the view.
     *
     * @param entity                        the entity being shown
     * @return                              <code>true</code> if the entity should be shown in the view
     */
    public boolean showEntity(Entity entity) {
        return true;
    }
    /**
     * Returns <code>true</code> if supplied property instance should be shown in the view.
     *
     * @param propertyInstance              the property instance being shown
     * @return                              <code>true</code> if the property instance should be shown in the view
     */
    public boolean showPropertyInstance(PropertyInstance propertyInstance) {
        return true;
    }
}
