package de.fzi.wim.oimodeler.viewfilter;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.vocabulary.*;

/**
 * Filter that hides all elements stemming from the lexical layer.
 */
public class LexicalLayerViewFilter implements ViewFilter {
    /**
     * Returns <code>true</code> if supplied entity should be shown in the view.
     *
     * @param entity                        the entity being shown
     * @return                              <code>true</code> if the entity should be shown in the view
     * @throws KAONException                thrown if there is an error
     */
    public boolean showEntity(Entity entity) throws KAONException {
        String uri=entity.getURI();
        return !uri.startsWith(KAONConnection.LEXICAL_OIMODEL_URI) || KAONVocabularyAdaptor.INSTANCE.getRoot().equals(uri);
    }
    /**
     * Returns <code>true</code> if supplied property instance should be shown in the view.
     *
     * @param propertyInstance              the property instance being shown
     * @return                              <code>true</code> if the property instance should be shown in the view
     * @throws KAONException                thrown if there is an error
     */
    public boolean showPropertyInstance(PropertyInstance propertyInstance) throws KAONException {
        return showEntity(propertyInstance.getProperty());
    }
}
