package de.fzi.wim.oimodeler.ui;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JButton;
import javax.swing.JRadioButton;

import edu.unika.aifb.kaon.defaultevolution.*;

import de.fzi.wim.guibase.localization.*;
import de.fzi.wim.guibase.configuration.*;

import de.fzi.wim.oimodeler.*;

/**
 * A dialog for setting up the default evolution parameters.
 */
public class SetUpDefaultEvolutionParametersDlg extends JDialog {
    /** The OI-modeler module. */
    protected OIModelerModule m_oimodelerModule;
    /** The evolution parameters being set up. */
    protected EvolutionParameters m_evolutionParameters;
    /** The buttons for 'orphaned concepts' options. */
    protected JRadioButton[] m_orphanedConcepts;
    /** The buttons for 'orphaned properties' options. */
    protected JRadioButton[] m_orphanedProperties;
    /** The buttons for 'property propagation' options. */
    protected JRadioButton[] m_propertyPropagation;
    /** The buttons for 'domain range shape' options. */
    protected JRadioButton[] m_domainRangeShape;
    /** The buttons for 'property domain empty' options. */
    protected JRadioButton[] m_propertyDomainEmpty;
    /** The buttons for 'property range empty' options. */
    protected JRadioButton[] m_propertyRangeEmpty;
    /** The buttons for 'instance consistency' options. */
    protected JRadioButton[] m_instanceConsistency;
    /** The buttons for 'concept hierarchy shape' options. */
    protected JRadioButton[] m_conceptHierarchyShape;
    /** The buttons for 'orphaned instances' options. */
    protected JRadioButton[] m_orphanedInstances;
    /** The buttons for 'orphaned property instances' options. */
    protected JRadioButton[] m_orphanedPropertyInstances;

    public SetUpDefaultEvolutionParametersDlg(OIModelerModule oimodelerModule,EvolutionParameters evolutionParameters) {
        super(oimodelerModule.getAppDriver().getMainFrameWindow(),oimodelerModule.getAppDriver().getLocalizationManager().getPhrase("oimodeler.setUpDefaultEvolutionParametersTitle"),true);
        m_oimodelerModule=oimodelerModule;
        m_evolutionParameters=evolutionParameters;
        LocalizationManager localizationManager=m_oimodelerModule.getAppDriver().getLocalizationManager();
        setDefaultCloseOperation(DISPOSE_ON_CLOSE);
        JButton okButton=localizationManager.getButton("oimodeler.OK");
        okButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                updateEvolutionParameters();
                dispose();
            }
        });
        JButton cancelButton=localizationManager.getButton("oimodeler.cancel");
        cancelButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                dispose();
            }
        });
        JPanel controlsPane=createControlsPane();
        controlsPane.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
        JPanel buttonsPane=new JPanel(new FlowLayout(FlowLayout.RIGHT));
        buttonsPane.add(okButton);
        buttonsPane.add(cancelButton);
        buttonsPane.setBorder(BorderFactory.createEmptyBorder(0,5,5,0));
        JPanel rootPane=new JPanel(new BorderLayout());
        rootPane.add(controlsPane,BorderLayout.CENTER);
        rootPane.add(buttonsPane,BorderLayout.SOUTH);
        setContentPane(rootPane);
        getRootPane().setDefaultButton(okButton);
        pack();
        setLocationRelativeTo(oimodelerModule.getAppDriver().getMainFrameWindow());
    }
    protected JRadioButton[] createRadioGroup(String titleID,int count,int selectedIndex,JPanel controlsPane) {
        ButtonGroup buttonGroup=new ButtonGroup();
        JRadioButton[] radioButtons=new JRadioButton[count];
        JPanel groupPane=new JPanel();
        groupPane.setLayout(new BoxLayout(groupPane,BoxLayout.Y_AXIS));
        for (int i=0;i<count;i++) {
            radioButtons[i]=createRadioButton(titleID+"_"+i,buttonGroup);
            groupPane.add(radioButtons[i]);
        }
        radioButtons[selectedIndex].setSelected(true);
        String title=m_oimodelerModule.getAppDriver().getLocalizationManager().getPhrase(titleID);
        groupPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(),title));
        controlsPane.add(groupPane);
        return radioButtons;
    }
    protected JRadioButton createRadioButton(String textID,ButtonGroup group) {
        String text=m_oimodelerModule.getAppDriver().getLocalizationManager().getPhrase(textID);
        JRadioButton button=new JRadioButton(text);
        group.add(button);
        return button;
    }
    protected JPanel createControlsPane() {
        JPanel controlsPane=new JPanel(new GridLayout(5,2));
        m_orphanedConcepts=createRadioGroup("oimodeler.evolutionParameters.orphanedConcepts",3,m_evolutionParameters.getOrphanedConcepts(),controlsPane);
        m_orphanedProperties=createRadioGroup("oimodeler.evolutionParameters.orphanedProperties",3,m_evolutionParameters.getOrphanedProperties(),controlsPane);
        m_propertyPropagation=createRadioGroup("oimodeler.evolutionParameters.propertyPropagation",3,m_evolutionParameters.getPropertyPropagation(),controlsPane);
        m_domainRangeShape=createRadioGroup("oimodeler.evolutionParameters.domainRangeShape",2,m_evolutionParameters.getDomainRangeShape(),controlsPane);
        m_propertyDomainEmpty=createRadioGroup("oimodeler.evolutionParameters.propertyDomainEmpty",2,m_evolutionParameters.getPropertyDomainEmpty(),controlsPane);
        m_propertyRangeEmpty=createRadioGroup("oimodeler.evolutionParameters.propertyRangeEmpty",2,m_evolutionParameters.getPropertyRangeEmpty(),controlsPane);
        m_instanceConsistency=createRadioGroup("oimodeler.evolutionParameters.instanceConsistency",2,m_evolutionParameters.getInstanceConsistency(),controlsPane);
        m_conceptHierarchyShape=createRadioGroup("oimodeler.evolutionParameters.conceptHierarchyShape",3,m_evolutionParameters.getConceptHierarchyShape(),controlsPane);
        m_orphanedInstances=createRadioGroup("oimodeler.evolutionParameters.orphanedInstances",3,m_evolutionParameters.getOrphanedInstances(),controlsPane);
        m_orphanedPropertyInstances=createRadioGroup("oimodeler.evolutionParameters.orphanedPropertyInstances",2,m_evolutionParameters.getOrphanedPropertyInstances(),controlsPane);
        return controlsPane;
    }
    protected int getSelectedIndex(JRadioButton[] radioButtons) {
        for (int i=0;i<radioButtons.length;i++)
            if (radioButtons[i].isSelected())
                return i;
        return -1;
    }
    protected void updateEvolutionParameters() {
        m_evolutionParameters.setOrphanedConcepts(getSelectedIndex(m_orphanedConcepts));
        m_evolutionParameters.setOrphanedProperties(getSelectedIndex(m_orphanedProperties));
        m_evolutionParameters.setPropertyPropagation(getSelectedIndex(m_propertyPropagation));
        m_evolutionParameters.setDomainRangeShape(getSelectedIndex(m_domainRangeShape));
        m_evolutionParameters.setPropertyDomainEmpty(getSelectedIndex(m_propertyDomainEmpty));
        m_evolutionParameters.setPropertyRangeEmpty(getSelectedIndex(m_propertyRangeEmpty));
        m_evolutionParameters.setInstanceConsistency(getSelectedIndex(m_instanceConsistency));
        m_evolutionParameters.setConceptHierarchyShape(getSelectedIndex(m_conceptHierarchyShape));
        m_evolutionParameters.setOrphanedInstances(getSelectedIndex(m_orphanedInstances));
        m_evolutionParameters.setOrphanedPropertyInstances(getSelectedIndex(m_orphanedPropertyInstances));
        saveEvolutionParameters(m_oimodelerModule.getAppDriver().getConfiguration().getSubConfiguration("defaultEvolutionParameters"),m_evolutionParameters);
    }
    public static void saveEvolutionParameters(Configuration configuration,EvolutionParameters evolutionParameters) {
        configuration.clear();
        configuration.setInt("orphanedConcepts",evolutionParameters.getOrphanedConcepts());
        configuration.setInt("orphanedProperties",evolutionParameters.getOrphanedProperties());
        configuration.setInt("propertyPropagation",evolutionParameters.getPropertyPropagation());
        configuration.setInt("domainRangeShape",evolutionParameters.getDomainRangeShape());
        configuration.setInt("propertyDomainEmpty",evolutionParameters.getPropertyDomainEmpty());
        configuration.setInt("propertyRangeEmpty",evolutionParameters.getPropertyRangeEmpty());
        configuration.setInt("instanceConsistency",evolutionParameters.getInstanceConsistency());
        configuration.setInt("conceptHierarchyShape",evolutionParameters.getConceptHierarchyShape());
        configuration.setInt("orphanedInstances",evolutionParameters.getOrphanedInstances());
        configuration.setInt("orphanedPropertyInstances",evolutionParameters.getOrphanedPropertyInstances());
    }
    public static void loadEvolutionParameters(Configuration configuration,EvolutionParameters evolutionParameters) {
        evolutionParameters.setOrphanedConcepts(configuration.getInt("orphanedConcepts",evolutionParameters.getOrphanedConcepts()));
        evolutionParameters.setOrphanedProperties(configuration.getInt("orphanedProperties",evolutionParameters.getOrphanedProperties()));
        evolutionParameters.setPropertyPropagation(configuration.getInt("propertyPropagation",evolutionParameters.getPropertyPropagation()));
        evolutionParameters.setDomainRangeShape(configuration.getInt("domainRangeShape",evolutionParameters.getDomainRangeShape()));
        evolutionParameters.setPropertyDomainEmpty(configuration.getInt("propertyDomainEmpty",evolutionParameters.getPropertyDomainEmpty()));
        evolutionParameters.setPropertyRangeEmpty(configuration.getInt("propertyRangeEmpty",evolutionParameters.getPropertyRangeEmpty()));
        evolutionParameters.setInstanceConsistency(configuration.getInt("instanceConsistency",evolutionParameters.getInstanceConsistency()));
        evolutionParameters.setConceptHierarchyShape(configuration.getInt("conceptHierarchyShape",evolutionParameters.getConceptHierarchyShape()));
        evolutionParameters.setOrphanedInstances(configuration.getInt("orphanedInstances",evolutionParameters.getOrphanedInstances()));
        evolutionParameters.setOrphanedPropertyInstances(configuration.getInt("orphanedPropertyInstances",evolutionParameters.getOrphanedPropertyInstances()));
    }
}
