package de.fzi.wim.oimodeler.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collections;
import java.util.Locale;
import java.util.Iterator;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.BorderLayout;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.vocabulary.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;
import edu.unika.aifb.kaon.evolutionlog.*;
import edu.unika.aifb.kaon.defaultevolution.*;

import de.fzi.wim.guibase.appdriver.*;
import de.fzi.wim.guibase.configuration.*;
import de.fzi.wim.guibase.selectionsource.*;
import de.fzi.wim.guibase.util.*;
import de.fzi.wim.guibase.localization.*;
import de.fzi.wim.guibase.graphview.layout.*;
import de.fzi.wim.guibase.graphview.lens.*;
import de.fzi.wim.guibase.graphview.view.*;

import de.fzi.wim.oimodeler.*;
import de.fzi.wim.oimodeler.commands.*;
import de.fzi.wim.oimodeler.selection.*;
import de.fzi.wim.oimodeler.inspector.*;
import de.fzi.wim.oimodeler.search.*;
import de.fzi.wim.oimodeler.clipboard.*;
import de.fzi.wim.oimodeler.inclusion.*;
import de.fzi.wim.oimodeler.viewfilter.*;
import de.fzi.wim.oimodeler.sidebar.*;
import de.fzi.wim.oimodeler.oimodelgraph.*;
import de.fzi.wim.oimodeler.oimodelgraph.graph.*;
import de.fzi.wim.oimodeler.oimodelgraph.view.*;

/**
 * The viewable in which the editor is presented.
 */
public class OIModelerViewable extends AbstractViewable {
    /** The registry for font names indexed by the language URI . */
    protected static final Map s_fontRegistry=new HashMap();
    static {
        registerFont("zh",new Font("SimSun",Font.PLAIN,14));
    }

    /** The registry for locales indexed by the language URI . */
    protected static final Map s_localeRegistry=new HashMap();
    static {
        registerLocale("en",Locale.US);
        registerLocale("de",Locale.GERMANY);
        registerLocale("fr",Locale.FRANCE);
        registerLocale("es",new Locale("es","ES"));
        registerLocale("zh",Locale.CHINA);
        registerLocale("ar",new Locale("ar","ar"));
    }

    /** The connection to KAON. */
    protected KAONConnection m_kaonConnection;
    /** The model of the application represented through the KAON API. */
    protected OIModel m_oimodel;
    /** The evolution information for KAON connection. */
    protected KAONConnectionEvolutionLogs m_kaonConnectionEvolutionLogs;
    /** Set to <code>true</code> if this OI-model is currently being processed. */
    protected boolean m_oimodelProcessed;
    /** The selection source manager. */
    protected OIModelerSelectionSourceManager m_oimodelerSelectionSourceManager;
    /** The selection for this viewable. */
    protected OIModelerSelectionModel m_oimodelerSelectionModel;
    /** The evolution parameters. */
    protected EvolutionParameters m_evolutionParameters;
    /** The evolution strategy for dependent ontologies. */
    protected DependentEvolutionStrategy m_dependentEvolutionStrategy;
    /** The listener for the OI-model events. */
    protected OIModelListener m_oimodelListener;
    /** The graph for the OI-modeler. */
    protected OIModelGraph m_oimodelGraph;
    /** The graph pane for the OI-modeler. */
    protected OIModelGraphPane m_oimodelGraphPane;
    /** The graph scrolls pane. */
    protected JPanel m_graphViewPane;
    /** The splitter between the graph and inspector. */
    protected JSplitPane m_graphInspectorSplit;
    /** The layouter for the graph. */
    protected Layouter m_layouter;
    /** The translate lens. */
    protected TranslateLens m_translateLens;
    /** The zoom lens. */
    protected ZoomLens m_zoomLens;
    /** The rotate lens. */
    protected RotateLens m_rotateLens;
    /** The hyperbolic view lens. */
    protected HyperbolicLens m_hyperbolicLens;
    /** The inspector for entities. */
    protected EntityInspector m_entityInspector;
    /** The URI of the current language. */
    protected String m_languageURI;
    /** The inclusion pane. */
    protected OIModelInclusionPane m_oimodelInclusionPane;
    /** The OI-model search pane. */
    protected OIModelSearchPane m_oimodelSearchPane;
    /** The clipboard pane. */
    protected ClipboardPane m_clipboardPane;
    /** Set to <code>true</code> if the inspector is live. */
    protected boolean m_inspectorIsLive;
    /** The view filter being used. */
    protected ViewFilter m_viewFilter;
    /** The sidebar. */
    protected OIModelerSideBar m_sideBar;

    /**
     * One viewable for the editor.
     *
     * @param oimodelerModule           the OI-modeler module
     * @param kaonConnection            the KAON connection
     * @param oimodel                   the OI-model
     * @throws KAONException            thrown if viewable cannot be created
     */
    public OIModelerViewable(final OIModelerModule oimodelerModule,KAONConnection kaonConnection,OIModel oimodel) throws KAONException {
        super(oimodelerModule);
        m_kaonConnection=kaonConnection;
        m_oimodel=oimodel;
        m_kaonConnectionEvolutionLogs=new KAONConnectionEvolutionLogs();
        m_oimodelListener=new OIModelHandler();
        m_oimodel.addOIModelListener(m_oimodelListener);
        m_viewFilter=new NullViewFilter();
        m_oimodelerSelectionModel=new OIModelerSelectionModel(this);
        m_oimodelerSelectionModel.addOIModelSelectionListener(new OIModelerSelectionListener() {
            public void selectedEntitiesChanged(OIModelerSelectionModel oimodelSelectionModel) {
                if (m_inspectorIsLive)
                    m_entityInspector.showSelection(m_oimodelerSelectionModel.getSelectedEntities());
            }
        });
        m_oimodelerSelectionSourceManager=new OIModelerSelectionSourceManager();
        m_oimodelerSelectionSourceManager.addSelectionSourceManagerListener(new SelectionSourceManagerListener() {
            public void activeSelectionSourceChanged(SelectionSourceManager selectionSourceManager,SelectionSource activeSelectionSource) {
                updateActions();
            }
            public void selectionChanged(SelectionSourceManager selectionSourceManager,SelectionSource selectionSource,boolean isActive) {
                if (isActive)
                    updateActions();
            }
        });
        m_evolutionParameters=new EvolutionParameters();
        m_dependentEvolutionStrategy=new DependentEvolutionStrategyImpl(m_kaonConnection) {
            public EvolutionParameters getEvolutionParameters(OIModel oimodel) {
                return m_evolutionParameters;
            }
        };
        SetUpDefaultEvolutionParametersDlg.loadEvolutionParameters(oimodelerModule.getAppDriver().getConfiguration().getSubConfiguration("defaultEvolutionParameters"),m_evolutionParameters);
        m_languageURI=KAONVocabularyAdaptor.INSTANCE.getLanguageURI("en");
        m_component=new JPanel(new BorderLayout());
        m_oimodelGraph=new OIModelGraph(new OIModelGraphAnchorAdaptor(),KAONVocabularyAdaptor.INSTANCE.getLanguageURI("en"));
        m_oimodelGraph.registerNamespacePrefix("http://www.w3.org/1999/02/22-rdf-syntax-ns#","rdf");
        m_oimodelGraph.registerNamespacePrefix("http://www.w3.org/2000/01/rdf-schema#","rdfs");
        m_oimodelGraph.registerNamespacePrefix("http://kaon.semanticweb.org/2001/11/kaon-lexical#","kaon");
        m_oimodelGraph.registerNamespacePrefix(oimodel.getURI(""),"o");
        m_oimodelGraphPane=new OIModelGraphPane(m_oimodelGraph,this);
        m_oimodelGraphPane.setPreferredSize(new Dimension(2000,2000));
        m_translateLens=new TranslateLens();
        m_zoomLens=new ZoomLens();
        m_rotateLens=new RotateLens();
        m_hyperbolicLens=new HyperbolicLens();
        LensSet lensSet=new LensSet();
        lensSet.addLens(m_translateLens);
        lensSet.addLens(m_zoomLens);
        lensSet.addLens(m_rotateLens);
        lensSet.addLens(m_hyperbolicLens);
        m_oimodelGraphPane.setLens(lensSet);
        m_layouter=new Layouter(new SpringLayoutStrategy(m_oimodelGraph));
        m_entityInspector=new EntityInspector(this);
        m_oimodelInclusionPane=new OIModelInclusionPane(this);
        m_oimodelInclusionPane.addPropertyChangeListener(new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent event) {
                if ("activeOIModel".equals(event.getPropertyName()))
                    m_oimodelGraphPane.repaint();
            }
        });
        try {
            m_oimodelSearchPane=(OIModelSearchPane)getModule().getAppDriver().getClassFactory().createElement("de.fzi.wim.oimodeler.search.OIModelSearchPane",new Object[] {this});
        }
        catch (Exception exception) {
            throw new KAONException("Error creating OIModelSearchPane.",exception);
        }
        m_clipboardPane=new ClipboardPane(this);
        m_graphViewPane=createGraphViewPane();
        m_graphInspectorSplit=new JSplitPane(JSplitPane.VERTICAL_SPLIT,m_graphViewPane,m_entityInspector);
        m_graphInspectorSplit.setDividerLocation(0.6);
        m_graphInspectorSplit.setResizeWeight(0.6);
        m_sideBar=new OIModelerSideBar(this);
        m_sideBar.setRemoveText(getModule().getAppDriver().getLocalizationManager().getPhrase("oimodeler.sidebar.item.removeItem"));
        m_sideBar.addElement(m_oimodelSearchPane,false);
        m_sideBar.addElement(m_clipboardPane,true);
        m_sideBar.addPropertyChangeListener(new PropertyChangeListener() {
             public void propertyChange(PropertyChangeEvent e) {
                updateActions();
            }
        });
        JSplitPane inclusionSidebarSplit=new JSplitPane(JSplitPane.VERTICAL_SPLIT,m_oimodelInclusionPane,m_sideBar);
        inclusionSidebarSplit.setDividerLocation(0.2);
        inclusionSidebarSplit.setResizeWeight(0.2);
        JSplitPane mainSplit=new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,m_graphInspectorSplit,inclusionSidebarSplit);
        mainSplit.setDividerLocation(0.70);
        mainSplit.setResizeWeight(0.9);
        m_component.add(mainSplit,BorderLayout.CENTER);
        m_oimodelProcessed=false;
        setLanguageURI(m_languageURI);
        m_layouter.start();
        m_inspectorIsLive=true;
        m_oimodelGraph.setIsLive(true);
    }
    /**
     * Creates the panel for graph view.
     *
     * @return                  the graph view pane
     */
    protected JPanel createGraphViewPane() {
        JComboBox scrollBarFunctionality=new JComboBox();
        JScrollBar scrollBar=new JScrollBar(JScrollBar.HORIZONTAL);
        new ScrollBarHandler(scrollBarFunctionality,scrollBar);
        JPanel controlsPane=new JPanel(new GridBagLayout());
        GridBagConstraints gbc=new GridBagConstraints();
        gbc.anchor=GridBagConstraints.WEST;
        gbc.fill=GridBagConstraints.HORIZONTAL;
        gbc.insets=new Insets(4,4,4,4);
        controlsPane.add(scrollBarFunctionality,gbc);
        gbc.weightx=1.0;
        gbc.gridx=1;
        controlsPane.add(scrollBar,gbc);
        JPanel graphViewPane=new JPanel(new BorderLayout());
        graphViewPane.add(controlsPane,BorderLayout.NORTH);
        graphViewPane.add(new JGraphScrollPane(m_oimodelGraphPane,m_translateLens),BorderLayout.CENTER);
        return graphViewPane;
    }
    /**
     * Returns the KAON connection.
     *
     * @return                  the KAON connection
     */
    public KAONConnection getKAONConnection() {
        return m_kaonConnection;
    }
    /**
     * Returns the OI-model.
     *
     * @return                      application's OI-model
     */
    public OIModel getOIModel() {
        return m_oimodel;
    }
    /**
     * Returns the active OI-model.
     *
     * @return                      the active OI-model
     */
    public OIModel getActiveOIModel() {
        return m_oimodelInclusionPane.getActiveOIModel();
    }
    /**
     * Returns the evolution information for the KAON connection.
     *
     * @return                      the evolution logs for the KAON connection
     */
    public KAONConnectionEvolutionLogs getKAONConnectionEvolutionLogs() {
        return m_kaonConnectionEvolutionLogs;
    }
    /**
     * Returns the view filter.
     *
     * @return                  the view filter
     */
    public ViewFilter getViewFilter() {
        return m_viewFilter;
    }
    /**
     * Returns the search pane.
     *
     * @return                  the search pane
     */
    public OIModelSearchPane getOIModelSearchPane() {
        return m_oimodelSearchPane;
    }
    /**
     * Returns the selection source manager.
     *
     * @return                  the selection source manager
     */
    public OIModelerSelectionSourceManager getOIModelerSelectionSourceManager() {
        return m_oimodelerSelectionSourceManager;
    }
    /**
     * Attaches this object to an anchor.
     *
     * @param anchor                        anchor to which this object  needs to be attached
     */
    public void setViewableAnchor(ViewableAnchor anchor) {
        super.setViewableAnchor(anchor);
        try {
            m_viewableAnchor.setTitle(m_module.getAppDriver().getLocalizationManager().format("oimodeler.titleURI",new Object[] { m_oimodel.getPhysicalURI() }));
        }
        catch (KAONException e) {
            m_viewableAnchor.setTitle(m_module.getAppDriver().getLocalizationManager().getPhrase("oimodeler.title"));
        }
    }
    /**
     * Disposes of this viewable.
     */
    public void dispose() {
        if (m_kaonConnection!=null) {
            m_oimodelerSelectionModel.clearSelectedEntities();
            m_layouter.stop();
            m_layouter=null;
            m_oimodelGraph.dispose();
            m_oimodelGraph=null;
            m_oimodelGraphPane=null;
            m_entityInspector.dispose();
            m_oimodelInclusionPane.dispose();
            m_oimodelInclusionPane=null;
            m_oimodelSearchPane.dispose();
            m_oimodelSearchPane=null;
            m_oimodel.removeOIModelListener(m_oimodelListener);
            m_oimodel=null;
            try {
                m_kaonConnection.close();
            }
            catch (KAONException e) {
                m_module.getAppDriver().displayErrorNotification(e);
            }
            try {
                m_kaonConnectionEvolutionLogs.close();
            }
            catch (KAONException e) {
                m_module.getAppDriver().displayErrorNotification(e);
            }
            m_kaonConnection=null;
            m_kaonConnectionEvolutionLogs=null;
            m_evolutionParameters=null;
            m_dependentEvolutionStrategy=null;
        }
    }
    /**
     * Returns the selection model of this viewable.
     *
     * @return                              the selection model of this viewable
     */
    public OIModelerSelectionModel getOIModelerSelectionModel() {
        return m_oimodelerSelectionModel;
    }
    /**
     * Returns the evolution parameters of this editor.
     *
     * @return                              the evolution parameters
     */
    public EvolutionParameters getEvolutionParameters() {
        return m_evolutionParameters;
    }
    /**
     * Returns the dependent evolution strategy.
     *
     * @return                              dependent evolution strategy
     */
    public DependentEvolutionStrategy getDependentEvolutionStrategy() {
        return m_dependentEvolutionStrategy;
    }
    /**
     * Returns the graph.
     *
     * @return                              the graph
     */
    public OIModelGraph getOIModelGraph() {
        return m_oimodelGraph;
    }
    /**
     * Returns the graph pane.
     *
     * @return                              the graph pane
     */
    public OIModelGraphPane getOIModelGraphPane() {
        return m_oimodelGraphPane;
    }
    /**
     * Returns the clipboard pane.
     *
     * @return                              the clipboard pane
     */
    public ClipboardPane getClipboardPane() {
        return m_clipboardPane;
    }
    /**
     * Adds the clipboard pane to the sidebar and activates it or removes it from the sidebar.
     *
     * @param show          <code>true</code> to show clipboard, <code>false</code> to hide it
     */
    public void showClipboardPane(boolean show) {
        int index=m_sideBar.findComponentIndex(m_clipboardPane);
        if (show) {
            if (index==-1) {
                m_sideBar.addItem(getModule().getAppDriver().getLocalizationManager().getPhrase("oimodeler.sidebar.item.clipboard"),null,getModule().getAppDriver().getLocalizationManager().getPhrase("oimodeler.sidebar.item.clipboard.description"),m_clipboardPane,true);
                index=m_sideBar.findComponentIndex(m_clipboardPane);
            }
            m_sideBar.setSelectedIndex(index);
        }
        else {
            if (index>=-1)
                m_sideBar.removeItem(index);
        }
    }
    /**
     * Determines whether the clipboard is shown in the sidebar or not.
     *
     * @return          <code>true</code> if clipboard is in sidebar <code>false</code> otherwise
     */
    public boolean isClipboardShown() {
        return m_sideBar.findComponentIndex(m_clipboardPane)>=0;
    }
    /**
     * Returns the sidebar.
     *
     * @return                              the sidebar
     */
    public OIModelerSideBar getSideBar() {
        return m_sideBar;
    }
    /**
     * Called when anchor is closing.
     */
    public void closing() {
        if (!m_oimodelProcessed) {
            if (saveOIModelIfNecessary())
                return;
            m_viewableAnchor.dispose();
        }
    }
    /**
     * Saves the OI-model if necessary.
     *
     * @return                              <code>true</code> if the operation was canceled
     */
    protected boolean saveOIModelIfNecessary() {
        try {
            if (hasUnsavedChanges(m_oimodel) || m_kaonConnectionEvolutionLogs.hasUnsavedChanges()) {
                String message=m_module.getAppDriver().getLocalizationManager().getPhrase("oimodeler.saveOIModelChanges");
                String title=m_module.getAppDriver().getLocalizationManager().getPhrase("OIModelerModule.title");
                int result=JOptionPane.showConfirmDialog(m_module.getAppDriver().getMainFrameWindow(),message,title,JOptionPane.YES_NO_CANCEL_OPTION);
                if (result==JOptionPane.YES_OPTION)
                    return !save();
                else if (result==JOptionPane.CANCEL_OPTION)
                    return true;
            }
            return false;
        }
        catch (KAONException error) {
            m_module.getAppDriver().displayErrorNotification(error);
            return true;
        }
    }
    /**
     * Returns <code>true</code> if supplied model or its children must to be saved.
     *
     * @param oimodel                       OI-model that is checked
     * @return                              <code>true</code> if this model or its children have unsaved changes
     * @throws KAONException                thrown if there is an error
     */
    protected boolean hasUnsavedChanges(OIModel oimodel) throws KAONException {
        if (oimodel.hasUnsavedChanges())
            return true;
        Iterator iterator=oimodel.getIncludedOIModels().iterator();
        while (iterator.hasNext()) {
            OIModel includedOIModel=(OIModel)iterator.next();
            if (hasUnsavedChanges(includedOIModel))
                return true;
        }
        return false;
    }
    /**
     * Saves the OI-model and the evolution log.
     *
     * @return                              <code>true</code> if the operation was successful
     */
    public boolean save() {
        try {
            try {
                m_module.getAppDriver().startWaitState();
                save(m_oimodel);
                m_kaonConnectionEvolutionLogs.save();
            }
            finally {
                m_module.getAppDriver().endWaitState();
            }
            return true;
        }
        catch (KAONException error) {
            m_module.getAppDriver().displayErrorNotification(error);
            return false;
        }
    }
    /**
     * Saves this OI-model and all its children it they need to be saved.
     *
     * @param oimodel                       the OI-model
     * @throws KAONException                thrown if there is an error
     */
    protected void save(OIModel oimodel) throws KAONException {
        if (oimodel.hasUnsavedChanges())
            oimodel.save();
        Iterator iterator=oimodel.getIncludedOIModels().iterator();
        while (iterator.hasNext()) {
            OIModel includedOIModel=(OIModel)iterator.next();
            save(includedOIModel);
        }
    }
    /**
     * Called when view is activated.
     */
    public void activated() {
        m_oimodelGraphPane.requestFocus();
    }
    /**
     * Checks whether the application can terminate.
     *
     * @return                              <code>true</code> if application can terminate
     */
    public boolean canExitApplication() {
        return !saveOIModelIfNecessary();
    }
    /**
     * Notifies this object that the associated OI-model is being processed and that any changes to the model should be disallowed.
     * This includes also closing this OI-model. Invoking this method and never calling the finish method will leave this editor
     * forever in the disabled state.
     */
    public void startOIModelProcessing() {
        m_oimodel.suspendEvents();
        m_oimodelProcessed=true;
        m_oimodelGraphPane.setEnabled(false);
        m_entityInspector.setBeingProcessed(false);
        m_component.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
    }
    /**
     * Notifies this object that the associated OI-model is not processed any more and that the changes can be allowed again.
     * This method can be called on any thread.
     */
    public void finishOIModelProcessing() {
        if (SwingUtilities.isEventDispatchThread())
            finishOIModelProcessingMainThread();
        else
            SwingUtilities.invokeLater(new Runnable() {
                public void run() {
                    finishOIModelProcessingMainThread();
                }
            });
    }
    /**
     * Method that finishes processing and that is called on the main thread.
     */
    protected void finishOIModelProcessingMainThread() {
        m_oimodelProcessed=false;
        m_oimodelGraphPane.setEnabled(true);
        m_entityInspector.setBeingProcessed(true);
        m_oimodel.resumeEvents();
        m_component.setCursor(null);
    }
    /**
     * Returns <code>true</code> if a command can be executed for this OI-model.
     *
     * @return                                  <code>true</code> if a command can be executed for this OI-model
     */
    public boolean commandsAreEnabled() {
        return !m_oimodelProcessed && super.commandsAreEnabled();
    }
    /**
     * Called to save the UI state of the viewable.
     *
     * @param configuration                 the configuration
     * @return                              <code>true</code> if the configuration saved
     */
    public boolean saveUIState(Configuration configuration) {
        try {
            configuration.setString("physicalURI",m_oimodel.getPhysicalURI());
            configuration.setString("languageURI",m_languageURI);
            configuration.setMap("connection",m_kaonConnection.getParameters());
            SetUpDefaultEvolutionParametersDlg.saveEvolutionParameters(configuration.getSubConfiguration("defaultEvolutionParameters"),m_evolutionParameters);
            return true;
        }
        catch (KAONException error) {
            m_module.getAppDriver().displayErrorNotification(error);
            return false;
        }
    }
    /**
     * Returns the URI of the current language.
     *
     * @return                              current language URI
     */
    public String getLanguageURI() {
        return m_languageURI;
    }
    /**
     * Sets the current language URI.
     *
     * @param languageURI                   the language URI
     */
    public void setLanguageURI(String languageURI) {
        m_languageURI=languageURI;
        try {
            m_oimodelGraphPane.setLanguageURI(m_languageURI);
            m_entityInspector.setLanguageURI(m_languageURI);
            m_sideBar.setLanguageURI(m_languageURI);
            m_clipboardPane.setLanguageURI(m_languageURI);
        }
        catch (KAONException e) {
            m_module.getAppDriver().displayErrorNotification(e);
        }
        updateActions();
    }
    /**
     * Changes the OI-model.
     *
     * @param events                        the list of events
     */
    public void changeOIModel(List events) {
        if (noChangesChangeReplica(events))
            executeCommandEx(new ChangeOIModelCmd(m_oimodel,events,getDependentEvolutionStrategy(),m_kaonConnectionEvolutionLogs,EvolutionLog.LOG_NORMAL,this));
    }
    /**
     * Returns <code>true</code> if none of the changes are directed to an OI-model that is a replica.
     *
     * @param events                        the list of events
     * @return                              <code>true</code> if none of the changes are directed to a replica OI-model
     */
    protected boolean noChangesChangeReplica(List events) {
        try {
            Iterator iterator=events.iterator();
            while (iterator.hasNext()) {
                ChangeEvent changeEvent=(ChangeEvent)iterator.next();
                OIModel oimodel=changeEvent.getOIModel();
                if (DistributedEvolutionStrategy.isReplica(oimodel)) {
                    String message=m_module.getAppDriver().getLocalizationManager().format("oimodeler.cantChangeReplica",new Object[] { oimodel.getLogicalURI() });
                    m_module.getAppDriver().displayNotification(message);
                    return false;
                }
            }
            return true;
        }
        catch (KAONException e) {
            m_module.getAppDriver().displayErrorNotification(e);
            return false;
        }
    }
    /**
     * Undoes an action.
     */
    public void undo() {
        try {
            EvolutionLog evolutionLog=m_kaonConnectionEvolutionLogs.getEvolutionLog(m_oimodel);
            List events=evolutionLog.readUndoChanges();
            executeCommandEx(new ChangeOIModelCmd(m_oimodel,events,null,m_kaonConnectionEvolutionLogs,EvolutionLog.LOG_UNDO,this));
        }
        catch (KAONException e) {
            m_module.getAppDriver().displayErrorNotification(e);
        }
    }
    /**
     * Returns <code>true</code> if undo can be performed.
     *
     * @return                              <code>true</code> if undo can be performed
     */
    public boolean canUndo() {
        if (commandsAreEnabled())
            try {
                EvolutionLog evolutionLog=m_kaonConnectionEvolutionLogs.getEvolutionLog(m_oimodel);
                return evolutionLog.canUndoChanges();
            }
            catch (KAONException e) {
            }
        return false;
    }
    /**
     * Redoes an action.
     */
    public void redo() {
        try {
            EvolutionLog evolutionLog=m_kaonConnectionEvolutionLogs.getEvolutionLog(m_oimodel);
            List events=evolutionLog.readRedoChanges();
            executeCommandEx(new ChangeOIModelCmd(m_oimodel,events,null,m_kaonConnectionEvolutionLogs,EvolutionLog.LOG_REDO,this));
        }
        catch (KAONException e) {
            m_module.getAppDriver().displayErrorNotification(e);
        }
    }
    /**
     * Returns <code>true</code> if redo can be performed.
     *
     * @return                              <code>true</code> if redo can be performed
     */
    public boolean canRedo() {
        if (commandsAreEnabled())
            try {
                EvolutionLog evolutionLog=m_kaonConnectionEvolutionLogs.getEvolutionLog(m_oimodel);
                return evolutionLog.canRedoChanges();
            }
            catch (KAONException e) {
            }
        return false;
    }
    /**
     * Determines whether the graph is shown.
     *
     * @param showGraph                     set to <code>true</code> if the graph is shown
     */
    public void setShowGraph(boolean showGraph) {
        try {
            m_oimodelGraph.setIsLive(showGraph);
            m_graphViewPane.setVisible(showGraph);
            if (showGraph)
                m_graphInspectorSplit.setDividerLocation(0.5);
        }
        catch (KAONException e) {
            m_module.getAppDriver().displayErrorNotification(e);
        }
    }
    /**
     * Returns <code>true</code> if the graph is shown.
     *
     * @return                              <code>true</code> if the graph is shown
     */
    public boolean getShowGraph() {
        return m_oimodelGraph.getIsLive();
    }
    /**
     * Determines whether the system objects should be shown.
     *
     * @param showSystemObjects             set to <code>true</code> if the system objects should be shown
     */
    public void setShowSystemObjects(boolean showSystemObjects) {
        if (showSystemObjects!=getShowSystemObjects()) {
            if (showSystemObjects)
                m_viewFilter=new NullViewFilter();
            else
                m_viewFilter=new LexicalLayerViewFilter();
            refresh();
        }
    }
    /**
     * Returns <code>true</code> if the system objects are shown.
     *
     * @return                              <code>true</code> if the system objects are shown
     */
    public boolean getShowSystemObjects() {
        return m_viewFilter instanceof NullViewFilter;
    }
    /**
     * Determines whether the inspector is shown.
     *
     * @param showInspector                 set to <code>true</code> if the inspector is shown
     */
    public void setShowInspector(boolean showInspector) {
        if (m_inspectorIsLive!=showInspector) {
            m_inspectorIsLive=showInspector;
            m_entityInspector.setVisible(m_inspectorIsLive);
            if (m_inspectorIsLive) {
                m_entityInspector.showSelection(m_oimodelerSelectionModel.getSelectedEntities());
                m_graphInspectorSplit.setDividerLocation(0.5);
            }
            else
                m_entityInspector.showSelection(Collections.EMPTY_SET);
        }
    }
    /**
     * Returns <code>true</code> if the inspector is shown.
     *
     * @return                              <code>true</code> if the inspector is shown
     */
    public boolean getShowInspector() {
        return m_inspectorIsLive;
    }
    /**
     * Returns the entity inspector.
     *
     * @return          the entity inspector
     */
    public EntityInspector getEntityInspector() {
        return m_entityInspector;
    }
    /**
     * Refreshes everything in this viewable.
     */
    public void refresh() {
        try {
            m_module.getAppDriver().startWaitState();
            try {
                Iterator oimodels=m_kaonConnection.getOpenOIModels().iterator();
                while (oimodels.hasNext()) {
                    OIModel oimodel=(OIModel)oimodels.next();
                    oimodel.refresh();
                }
                m_kaonConnectionEvolutionLogs.refresh();
            }
            finally {
                m_module.getAppDriver().endWaitState();
            }
        }
        catch (KAONException e) {
            m_module.getAppDriver().displayErrorNotification(e);
        }
    }
    /**
     * Called when an error is encountered while loading an entity. This method then consults
     * the inspector to prevent multiple error messages from occuring when the inspected entity
     * cannot be loaded.
     *
     * @param entity                        the entity
     * @param error                         the error that occured
     */
    public void errorLoadingEntity(Entity entity,Throwable error) {
        if (!m_inspectorIsLive || m_entityInspector.shouldReportError(entity))
            m_module.getAppDriver().displayErrorNotification(error);
    }
    /**
     * Registers the font for given language code.
     *
     * @param language                      the language code
     * @param font                          the font
     */
    public static void registerFont(String language,Font font) {
        String languageURI=KAONVocabularyAdaptor.INSTANCE.getLanguageURI(language);
        s_fontRegistry.put(languageURI,font);
    }
    /**
     * Returns the font for the given language URI.
     *
     * @param languageURI                   the language URI
     * @return                              the font
     */
    public static Font getFont(String languageURI) {
        return (Font)s_fontRegistry.get(languageURI);
    }
    /**
     * Sets the font for the given language URI to given component.
     *
     * @param languageURI                   the language URI
     * @param component                     the component
     */
    public static void setFont(String languageURI,JComponent component) {
        Font defaultFont=(Font)component.getClientProperty("oimodeler.defaultFont");
        if (defaultFont==null) {
            defaultFont=component.getFont();
            component.putClientProperty("oimodeler.defaultFont",defaultFont);
        }
        Font newFont=getFont(languageURI);
        if (newFont==null)
            newFont=defaultFont;
        component.setFont(newFont);
    }
    /**
     * Registers the locale for given language code.This information is used for selecting
     * the correct input context.
     *
     * @param language                      the language code
     * @param locale                        the locale
     */
    public static void registerLocale(String language,Locale locale) {
        String languageURI=KAONVocabularyAdaptor.INSTANCE.getLanguageURI(language);
        s_localeRegistry.put(languageURI,locale);
    }
    /**
     * Returns the locate for given language URI. If no locale is registered, the current locale is returned.
     *
     * @param languageURI                   the URI of the language
     * @return                              the locale for given language
     */
    public static Locale getLocale(String languageURI) {
        Locale locale=(Locale)s_localeRegistry.get(languageURI);
        if (locale==null)
            return Locale.getDefault();
        else
            return locale;
    }

    /**
     * The listener for the OI-model events.
     */
    protected class OIModelHandler implements OIModelListener {
        public void modelChanged(OIModel oimodel,List changeEvents) {
            boolean refresh=false;
            Iterator iterator=changeEvents.iterator();
            while (iterator.hasNext()) {
                ChangeEvent changeEvent=(ChangeEvent)iterator.next();
                if ((changeEvent instanceof AddIncludedOIModel) || (changeEvent instanceof RemoveIncludedOIModel))
                    refresh=true;
            }
            if (refresh)
                SwingUtilities.invokeLater(new Runnable() {
                    public void run() {
                        refresh();
                    }
                });
        }
        public void modelRefreshed(OIModel oimodel) {
            try {
                m_oimodelerSelectionModel.setSelectedEntities(Collections.singleton(m_oimodel.getRootConcept()));
            }
            catch (KAONException error) {
                m_module.getAppDriver().displayErrorNotification(error);
            }
        }
        public void modelDeleted(OIModel oimodel) {
            getViewableAnchor().dispose();
        }
    }

    /**
     * The adaptor that converts the OIModelerViewable to OIModelGraphAnchor.
     */
    protected class OIModelGraphAnchorAdaptor implements OIModelGraphAnchor {

        public LocalizationManager getLocalizationManager() {
            return getModule().getAppDriver().getLocalizationManager();
        }
        public void notifyError(Throwable throwable) {
            getModule().getAppDriver().displayErrorNotification(throwable);
        }
        public String getLanguageURI() {
            return OIModelerViewable.this.getLanguageURI();
        }
        public void changeOIModel(List changeEvents) {
            OIModelerViewable.this.changeOIModel(changeEvents);
        }
        public OIModel getOIModel() {
            return OIModelerViewable.this.getOIModel();
        }
        public OIModel getActiveOIModel() {
            return OIModelerViewable.this.getActiveOIModel();
        }
        public ThreadPool getThreadPool() {
            return getModule().getAppDriver().getThreadPool();
        }
        public ViewFilter getViewFilter() {
            return OIModelerViewable.this.getViewFilter();
        }
        public String replaceURIPrefix(String uri) {
            return OIModelerViewable.this.getOIModelGraph().replaceURIPrefix(uri);
        }
    }

    /**
     * The handler for scrollbar and scrollbar functionality combo box.
     */
    protected class ScrollBarHandler implements ActionListener,AdjustmentListener {
        /** The functionality combo box. */
        protected JComboBox m_functionality;
        /** The scroll bar. */
        protected JScrollBar m_scrollBar;
        /** Set to <code>true</code> if the scroll bar is currently updating. */
        protected boolean m_scrollBarUpdating;

        public ScrollBarHandler(JComboBox functionality,JScrollBar scrollBar) {
            m_functionality=functionality;
            m_functionality.addItem(m_module.getAppDriver().getLocalizationManager().getPhrase("oimodeler.zoom"));
            m_functionality.addItem(m_module.getAppDriver().getLocalizationManager().getPhrase("oimodeler.rotate"));
            m_functionality.addItem(m_module.getAppDriver().getLocalizationManager().getPhrase("oimodeler.hyperbolic"));
            m_functionality.addActionListener(this);
            m_scrollBar=scrollBar;
            m_scrollBar.addAdjustmentListener(this);
            // this is to update the scroll bar initially
            actionPerformed(null);
        }
        public void actionPerformed(ActionEvent e) {
            m_scrollBarUpdating=true;
            switch (m_functionality.getSelectedIndex()) {
                case 0:
                    m_scrollBar.setMinimum(-26);
                    m_scrollBar.setMaximum(25);
                    m_scrollBar.setVisibleAmount(4);
                    m_scrollBar.setValue((int)(10.0*Math.log(m_zoomLens.getZoomFactor())/Math.log(2.0)));
                    break;
                case 1:
                    m_scrollBar.setMinimum(0);
                    m_scrollBar.setMaximum(359);
                    m_scrollBar.setVisibleAmount(1);
                    m_scrollBar.setValue((int)m_rotateLens.getRotationAngle());
                    break;
                case 2:
                    m_scrollBar.setMinimum(0);
                    m_scrollBar.setMaximum(108);
                    m_scrollBar.setVisibleAmount(8);
                    m_scrollBar.setValue((int)m_hyperbolicLens.getDistortionFactor());
                    break;
            }
            m_scrollBarUpdating=false;
        }
        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (!m_scrollBarUpdating)
                switch (m_functionality.getSelectedIndex()) {
                    case 0:
                        m_zoomLens.setZoomFactor(Math.pow(2,e.getValue()/10.0));
                        break;
                    case 1:
                        m_rotateLens.setRotationAngle(e.getValue());
                        break;
                    case 2:
                        m_hyperbolicLens.setDistortionFactor(e.getValue());
                        break;
                }
        }
    }
}
