package de.fzi.wim.oimodeler.ui;

import java.util.Set;
import java.util.Iterator;
import java.util.Arrays;
import java.io.File;
import java.awt.Insets;
import java.awt.Dimension;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;

import de.fzi.wim.guibase.util.*;
import de.fzi.wim.guibase.localization.*;
import de.fzi.wim.guibase.configuration.*;
import de.fzi.wim.guibase.appdriver.AbstractModule;

/**
 * Dialog that allows entering infromation about an OI-model.
 */
public class OIModelParametersDlg extends JDialog {
    /** The configuration parameters. */
    protected Configuration m_configuration;
    /** The logical URI. */
    protected JComboBox m_oimodelLogicalURI;
    /** The physical URI. */
    protected JTextField m_oimodelPhysicalURI;
    /** The module. */
    protected AbstractModule m_module;
    /** The connection to duplicate. */
    protected KAONConnection m_kaonConnection;
    /** Set to <code>true</code> if dialog is contirmed. */
    protected boolean m_confirmed;

    public OIModelParametersDlg(AbstractModule module,KAONConnection kaonConnection,String titleID) {
        super(module.getAppDriver().getMainFrameWindow(),module.getAppDriver().getLocalizationManager().getPhrase(titleID),true);
        m_module=module;
	    m_kaonConnection=kaonConnection;
        m_configuration=m_module.getAppDriver().getConfiguration().getSubConfiguration(titleID);
        final LocalizationManager localizationManager=m_module.getAppDriver().getLocalizationManager();
        m_oimodelPhysicalURI=new JTextField();
        m_oimodelPhysicalURI.setText(m_configuration.getString("physicalURI",""));
        m_oimodelPhysicalURI.setPreferredSize(new Dimension(200,m_oimodelPhysicalURI.getPreferredSize().height));
        JButton browseButton=localizationManager.getButton("oimodeler.browse");
        browseButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JFileChooserEx fileChooser=new JFileChooserEx();
                ExtensionFileFilter defaultFilter=new ExtensionFileFilter(localizationManager,"oimodeler.allOIModelerFiles",new String[] { "kaon" });
                fileChooser.addChoosableFileFilter(defaultFilter);
                String currentDirectory=m_configuration.getString("currentDirectory");
                if (currentDirectory!=null)
                    fileChooser.setCurrentDirectory(new File(currentDirectory));
                if (fileChooser.showOpenDialog(m_module.getAppDriver().getMainFrameWindow())==JFileChooserEx.APPROVE_OPTION) {
                    String uri=fileChooser.getSelectedFileEx().toURI().toString();
                    m_oimodelPhysicalURI.setText(uri);
                    m_configuration.setString("currentDirectory",fileChooser.getCurrentDirectory().getAbsolutePath());
                }
            }
        });
        JPanel physicalURIAndButton=new JPanel(new BorderLayout(10,0));
        physicalURIAndButton.add(m_oimodelPhysicalURI,BorderLayout.CENTER);
        physicalURIAndButton.add(browseButton,BorderLayout.EAST);
        LogicalURIComboBoxModel logicalURIComboBoxModel=new LogicalURIComboBoxModel();
        m_oimodelLogicalURI=new JComboBox(logicalURIComboBoxModel);
        m_oimodelLogicalURI.setSelectedItem(m_configuration.getString("logicalURI",""));
        m_oimodelLogicalURI.setPreferredSize(new Dimension(200,m_oimodelLogicalURI.getPreferredSize().height));
        m_oimodelLogicalURI.setEditable(true);
        m_oimodelLogicalURI.addPopupMenuListener(logicalURIComboBoxModel);
        setDefaultCloseOperation(DISPOSE_ON_CLOSE);
        JButton okButton=localizationManager.getButton("oimodeler.OK");
        okButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                m_confirmed=true;
                m_configuration.setString("logicalURI",getOIModelLogicalURI());
                m_configuration.setString("physicalURI",getOIModelPhysicalURI());
                m_module.getAppDriver().saveConfiguration();
                dispose();
            }
        });
        JButton cancelButton=localizationManager.getButton("oimodeler.cancel");
        cancelButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                dispose();
            }
        });
        JPanel controlsPane=new JPanel(new GridBagLayout());
        String kaonConnectionClass=m_kaonConnection.getClass().getName();
        boolean isServer="edu.unika.aifb.kaon.engineeringserver.client.RemoteKAONConnection".equals(kaonConnectionClass) || "edu.unika.aifb.kaon.engineeringserver.client.DirectKAONConnection".equals(kaonConnectionClass);
        int row=0;
        if (!isServer)
            addPair(controlsPane,row++,"oimodeler.oimodelPhysicalURI",physicalURIAndButton,true);
        else
            m_oimodelPhysicalURI.setText("");
        addPair(controlsPane,row++,"oimodeler.oimodelLogicalURI",m_oimodelLogicalURI,true);
        controlsPane.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
        JPanel buttonsPane=new JPanel(new FlowLayout(FlowLayout.RIGHT));
        buttonsPane.add(okButton);
        buttonsPane.add(cancelButton);
        buttonsPane.setBorder(BorderFactory.createEmptyBorder(0,5,5,0));
        JPanel rootPane=new JPanel(new BorderLayout());
        rootPane.add(controlsPane,BorderLayout.CENTER);
        rootPane.add(buttonsPane,BorderLayout.SOUTH);
        setContentPane(rootPane);
        getRootPane().setDefaultButton(okButton);
        pack();
        setLocationRelativeTo(m_module.getAppDriver().getMainFrameWindow());
    }
    /**
     * Returns whether dialog was confirmed with OK.
     *
     * @return                      <code>true</code> if dialog has been confirmed
     */
    public boolean isConfirmed() {
        return m_confirmed;
    }
    /**
     * Returns the logical URI of the OI-model.
     *
     * @return                      the URI of the OI-model
     */
    public String getOIModelLogicalURI() {
        String logicalURI=(String)m_oimodelLogicalURI.getSelectedItem();
        if (logicalURI==null)
            return "";
        else
            return logicalURI.trim();
    }
    /**
     * Returns the physical URI of the OI-model.
     *
     * @return                      the URI of the OI-model
     */
    public String getOIModelPhysicalURI() {
        return m_oimodelPhysicalURI.getText().trim();
    }
    protected JLabel addPair(JPanel panel,int row,String labelText,JComponent control,boolean fill) {
        JLabel label=null;
        GridBagConstraints gbc=new GridBagConstraints();
        gbc.insets=new Insets(4,4,4,4);
        gbc.gridy=row;
        if (labelText!=null) {
            gbc.anchor=GridBagConstraints.WEST;
            gbc.gridx=0;
            label=m_module.getAppDriver().getLocalizationManager().getLabel(labelText);
            panel.add(label,gbc);
        }
        if (control!=null) {
            gbc.gridx=1;
            gbc.weightx=1.0f;
            if (fill)
                gbc.fill=GridBagConstraints.HORIZONTAL;
            panel.add(control,gbc);
        }
        return label;
    }

    /**
     * The chooser for the logical OI-model URI.
     */
    protected class LogicalURIComboBoxModel extends AbstractListModel implements PopupMenuListener,ComboBoxModel {
        /** Selected URI. */
        protected String m_selectedURI;
        /** All URIs in the model. */
        protected String[] m_logicalURIs;

        public LogicalURIComboBoxModel() {
            m_logicalURIs=new String[0];
        }
        public void refresh() {
            try {
                Set logicalURIs=m_kaonConnection.getAllOIModelLogicalURIs();
                m_logicalURIs=new String[logicalURIs.size()];
                Iterator iterator=logicalURIs.iterator();
                int index=0;
                while (iterator.hasNext())
                    m_logicalURIs[index++]=(String)iterator.next();
                Arrays.sort(m_logicalURIs);
            }
            catch (KAONException e) {
                m_logicalURIs=new String[0];
                m_module.getAppDriver().displayErrorNotification(e);
            }
            fireContentsChanged(this,-1,-1);
        }
        public void setSelectedItem(Object anObject) {
            if (m_selectedURI!=null && !m_selectedURI.equals(anObject) || m_selectedURI==null && anObject!=null) {
                m_selectedURI=(String)anObject;
                fireContentsChanged(this,-1,-1);
            }
        }
        public Object getSelectedItem() {
            return m_selectedURI;
        }
        public int getSize() {
            return m_logicalURIs.length;
        }
        public Object getElementAt(int index) {
            return m_logicalURIs[index];
        }
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            refresh();
        }
    }
}
