package de.fzi.wim.oimodeler.ui;

import java.awt.Insets;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

import de.fzi.wim.guibase.localization.*;
import de.fzi.wim.guibase.util.*;
import de.fzi.wim.guibase.configuration.*;

import de.fzi.wim.oimodeler.*;

/**
 * Simple dialog for entering the data about a new entity.
 */
public class NewEntityDlg extends JDialog {
    /** The 'New Concept' type. */
    public static final int NEW_CONCEPT_TYPE=0;
    /** The 'New Property' type. */
    public static final int NEW_PROPERTY_TYPE=1;
    /** The 'New Instance' type. */
    public static final int NEW_INSTANCE_TYPE=2;

    /** Editor for entity name. */
    protected JTextField m_entityName;
    /** Determines whether label should be added. */
    protected JCheckBox m_addLabel;
    /** Button group for the uri creation. */
    protected ButtonGroup m_uriCreation;
    /** Set to <code>true</code> if dialog is contirmed. */
    protected boolean m_confirmed;
    /** The application's configuration. */
    protected Configuration m_configuration;

    public NewEntityDlg(OIModelerModule oimodelerModule,final int type) {
        super(oimodelerModule.getAppDriver().getMainFrameWindow(),true);
        m_configuration=oimodelerModule.getAppDriver().getConfiguration();
        LocalizationManager localizationManager=oimodelerModule.getAppDriver().getLocalizationManager();
        m_addLabel=new JCheckBox();
        m_uriCreation=new ButtonGroup();
        JRadioButton createUriFromLabel=localizationManager.getRadioButton("oimodeler.newEntityDlg.createUriFromLabel");
        createUriFromLabel.setActionCommand("fromlabel");
        JRadioButton createNewUri=localizationManager.getRadioButton("oimodeler.newEntityDlg.createNewUri");
        createNewUri.setActionCommand("newuri");
        m_uriCreation.add(createUriFromLabel);
        m_uriCreation.add(createNewUri);
        final String typeName=getTypeName(type);
        if (type==NEW_CONCEPT_TYPE) {
            setTitle(localizationManager.getPhrase("oimodeler.newConcept"));
        }
        else if (type==NEW_PROPERTY_TYPE) {
            setTitle(localizationManager.getPhrase("oimodeler.newProperty"));
        }
        else if (type==NEW_INSTANCE_TYPE) {
            setTitle(localizationManager.getPhrase("oimodeler.newInstance"));
        }
        m_addLabel.setSelected(m_configuration.getBoolean("oimodeler.newEntityDlg."+typeName+".addLabel",true));
        createUriFromLabel.setSelected(m_configuration.getBoolean("oimodeler.newEntityDlg."+typeName+".createUriFromLabel",true));
        createNewUri.setSelected(!createUriFromLabel.isSelected());
        
        setDefaultCloseOperation(DISPOSE_ON_CLOSE);
        m_entityName=new JTextField();
        m_entityName.setPreferredSize(new Dimension(300,m_entityName.getPreferredSize().height));
        Mnemonics.setText(m_addLabel,localizationManager.getPhrase("oimodeler.addLabel"));
        JButton okButton=localizationManager.getButton("oimodeler.OK");
        okButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                m_confirmed=true;
                // store the configuration
                m_configuration.setBoolean("oimodeler.newEntityDlg."+typeName+".addLabel",m_addLabel.isSelected());
                m_configuration.setBoolean("oimodeler.newEntityDlg."+typeName+".createUriFromLabel","fromlabel".equals(m_uriCreation.getSelection().getActionCommand()));
                dispose();
            }
        });
        JButton cancelButton=localizationManager.getButton("oimodeler.cancel");
        cancelButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                dispose();
            }
        });
        JPanel propertyPane=new JPanel(new GridBagLayout());
        GridBagConstraints gbc=new GridBagConstraints(0,0,1,1,1,0,GridBagConstraints.CENTER,GridBagConstraints.HORIZONTAL,new Insets(5,5,0,5),0,0);
        JLabel label;
        if (type==NEW_CONCEPT_TYPE)
            label=localizationManager.getLabel("oimodeler.newConceptName");
        else if (type==NEW_PROPERTY_TYPE)
            label=localizationManager.getLabel("oimodeler.newPropertyName");
        else
            label=localizationManager.getLabel("oimodeler.newInstanceName");
        label.setHorizontalAlignment(JLabel.LEFT);
        propertyPane.add(label,gbc);
        gbc.gridy++;
        propertyPane.add(m_entityName,gbc);
        gbc.gridy++;
        propertyPane.add(m_addLabel,gbc);
        gbc.gridy++;
        gbc.insets.bottom=0;
        propertyPane.add(createUriFromLabel,gbc);
        gbc.gridy++;
        gbc.insets.top=0;
        propertyPane.add(createNewUri,gbc);
        JPanel buttonsPane=new JPanel(new FlowLayout(FlowLayout.RIGHT));
        buttonsPane.add(okButton);
        buttonsPane.add(cancelButton);
        gbc.insets.top=5;
        gbc.insets.bottom=5;
        gbc.gridy++;
        propertyPane.add(buttonsPane,gbc);
        setContentPane(propertyPane);
        getRootPane().setDefaultButton(okButton);
        pack();
        setLocationRelativeTo(oimodelerModule.getAppDriver().getMainFrameWindow());
    }
    /**
     * Returns the name of the specified type. (Used for storing the configuration according to the type of the dialog.)
     *
     * @param   type                type to get the name for
     * @return                      name of the type
     */
    protected String getTypeName(int type) {
        switch(type) {
            case NEW_CONCEPT_TYPE:
                return "Concept";
            case NEW_PROPERTY_TYPE:
                return "Property";
            case NEW_INSTANCE_TYPE:
                return "Instance";
        }
        return "";
    }
    /**
     * Returns the name of the new entity.
     *
     * @return                      name of the new entity
     */
    public String getEntityName() {
        return m_entityName.getText();
    }
    /**
     * Returns whether dialog was confirmed with OK.
     *
     * @return                      <code>true</code> if the dialog was confirmed
     */
    public boolean isConfirmed() {
        return m_confirmed;
    }
    /**
     * Returns <code>true</code> if the label should be added.
     *
     * @return                      <code>true</code> if the label should be added
     */
    public boolean shouldAddLabel() {
        return m_addLabel.isSelected();
    }
    /**
     * Determines whether the URI should be created from scratch or by using the specified label.
     *
     * @return                      <code>true</code> if the label should be created by using the label, <code>false</code> if the URI should be generated newly
     */
    public boolean shouldCreateUriFromLabel() {
        return "fromlabel".equals(m_uriCreation.getSelection().getActionCommand());
    }
}
