package de.fzi.wim.oimodeler.ui;

import java.util.List;
import java.util.Iterator;
import java.util.Map;
import java.util.HashMap;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JPanel;
import javax.swing.JDialog;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

import edu.unika.aifb.kaon.api.*;
import edu.unika.aifb.kaon.api.oimodel.*;
import edu.unika.aifb.kaon.api.change.*;

import de.fzi.wim.guibase.localization.*;

/**
 * A dialog displaying the results of the evolution strategy.
 */
public class EvolutionDetailsDlg extends JDialog {
    /** The viewable. */
    protected OIModelerViewable m_oimodelerViewable;
    /** Set to <code>true</code> if dialog is contirmed. */
    protected boolean m_confirmed;

    public EvolutionDetailsDlg(OIModelerViewable oimodelerViewable,List changeEvents) throws KAONException {
        super(oimodelerViewable.getModule().getAppDriver().getMainFrameWindow(),true);
        setDefaultCloseOperation(DISPOSE_ON_CLOSE);
        m_oimodelerViewable=oimodelerViewable;
        LocalizationManager localizationManager=oimodelerViewable.getModule().getAppDriver().getLocalizationManager();
        setTitle(localizationManager.getPhrase("oimodeler.evolutionDetails.title"));
        ModelBuilder modelBuilder=new ModelBuilder();
        modelBuilder.processEventList(changeEvents);
        JTree tree=new JTree(new DefaultTreeModel(modelBuilder.getRoot()));
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        DefaultTreeCellRenderer cellRenderer=(DefaultTreeCellRenderer)tree.getCellRenderer();
        cellRenderer.setOpenIcon(null);
        cellRenderer.setClosedIcon(null);
        cellRenderer.setLeafIcon(null);
        JButton applyChangesButton=localizationManager.getButton("oimodeler.applyChanges");
        applyChangesButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                m_confirmed=true;
                dispose();
            }
        });
        JButton cancelButton=localizationManager.getButton("oimodeler.cancel");
        cancelButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                dispose();
            }
        });
        JPanel buttonsPane=new JPanel(new FlowLayout(FlowLayout.RIGHT));
        buttonsPane.add(applyChangesButton);
        buttonsPane.add(cancelButton);
        JPanel propertyPane=new JPanel(new BorderLayout(5,5));
        JScrollPane scrollPane=new JScrollPane(tree);
        scrollPane.setPreferredSize(new Dimension(600,400));
        String treeLabel=localizationManager.getPhrase("oimodeler.allChanges");
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5,5,0,5),BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(),treeLabel)));
        propertyPane.add(scrollPane);
        propertyPane.add(buttonsPane,BorderLayout.SOUTH);
        setContentPane(propertyPane);
        getRootPane().setDefaultButton(applyChangesButton);
        pack();
        setLocationRelativeTo(m_oimodelerViewable.getModule().getAppDriver().getMainFrameWindow());
    }
    /**
     * Returns whether dialog was confirmed with OK.
     *
     * @return                      <code>true</code> if the dialog was confirmed
     */
    public boolean isConfirmed() {
        return m_confirmed;
    }

    /**
     * The responsible for building the tree model.
     */
    protected class ModelBuilder implements ChangeVisitor {
        /** The root of the tree being built. */
        protected DefaultMutableTreeNode m_root;
        /** The map of events to their corresponding nodes. */
        protected Map m_eventsToNodes;
        /** The localization manager. */
        protected LocalizationManager m_localizationManager;

        /**
         * Creates an instance of this class.
         */
        public ModelBuilder() {
            m_eventsToNodes=new HashMap();
            m_root=new DefaultMutableTreeNode();
            m_localizationManager=m_oimodelerViewable.getModule().getAppDriver().getLocalizationManager();
        }
        public DefaultMutableTreeNode getRoot() {
            return m_root;
        }
        protected void createNode(ChangeEvent changeEvent,Object[] arguments) {
            createNode(changeEvent,null,arguments);
        }
        protected void createNode(ChangeEvent changeEvent,String supplement,Object[] arguments) {
            String eventClassName=changeEvent.getClass().getName();
            int dotPosition=eventClassName.lastIndexOf('.');
            String eventName=eventClassName.substring(dotPosition+1);
            String phraseKey="oimodeler.evolution."+eventName;
            String messageKey;
            if (supplement==null)
                messageKey=phraseKey;
            else
                messageKey=phraseKey+"."+supplement;
            String label=m_localizationManager.format(messageKey,arguments);
            m_eventsToNodes.put(changeEvent,new DefaultMutableTreeNode(label));
        }
        protected void createNodes(List changeEvents) throws KAONException {
            Iterator iterator=changeEvents.iterator();
            while (iterator.hasNext()) {
                ChangeEvent changeEvent=(ChangeEvent)iterator.next();
                changeEvent.accept(this);
            }
        }
        protected void linkNodes(List changeEvents) {
            Iterator iterator=changeEvents.iterator();
            while (iterator.hasNext()) {
                ChangeEvent changeEvent=(ChangeEvent)iterator.next();
                DefaultMutableTreeNode node=(DefaultMutableTreeNode)m_eventsToNodes.get(changeEvent);
                ChangeEvent causeEvent=changeEvent.getCause();
                DefaultMutableTreeNode parentNode;
                if (causeEvent==null)
                    parentNode=m_root;
                else
                    parentNode=(DefaultMutableTreeNode)m_eventsToNodes.get(causeEvent);
                parentNode.add(node);
            }
        }
        public void processEventList(List changeEvents) throws KAONException {
            createNodes(changeEvents);
            linkNodes(changeEvents);
        }
        public void visit(AddEntity event) throws KAONException {
            String type=null;
            if (event.getEntity() instanceof Concept)
                type="concept";
            else if (event.getEntity() instanceof Property)
                type="property";
            else if (event.getEntity() instanceof Instance)
                type="instance";
            createNode(event,type,new Object[] { getEntityString(event.getEntity()) });
        }
        public void visit(RemoveEntity event) throws KAONException {
            String type=null;
            if (event.getEntity() instanceof Concept)
                type="concept";
            else if (event.getEntity() instanceof Property)
                type="property";
            else if (event.getEntity() instanceof Instance)
                type="instance";
            createNode(event,type,new Object[] { getEntityString(event.getEntity()) });
        }
        public void visit(AddSubConcept event) throws KAONException {
            createNode(event,new Object[] { getEntityString(event.getSuperConcept()),getEntityString(event.getSubConcept()) });
        }
        public void visit(RemoveSubConcept event) throws KAONException {
            createNode(event,new Object[] { getEntityString(event.getSuperConcept()),getEntityString(event.getSubConcept()) });
        }
        public void visit(AddPropertyDomain event) throws KAONException {
            createNode(event,new Object[] { getEntityString(event.getProperty()),getEntityString(event.getConcept()) });
        }
        public void visit(RemovePropertyDomain event) throws KAONException {
            createNode(event,new Object[] { getEntityString(event.getProperty()),getEntityString(event.getConcept()) });
        }
        public void visit(AddPropertyRange event) throws KAONException {
            createNode(event,new Object[] { getEntityString(event.getProperty()),getEntityString(event.getConcept()) });
        }
        public void visit(RemovePropertyRange event) throws KAONException {
            createNode(event,new Object[] { getEntityString(event.getProperty()),getEntityString(event.getConcept()) });
        }
        public void visit(SetPropertyIsAttribute event) throws KAONException {
            createNode(event,event.getIsAttribute() ? "true" : "false",new Object[] { getEntityString(event.getProperty()) });
        }
        public void visit(SetMinimumCardinality event) throws KAONException {
            createNode(event,new Object[] { getEntityString(event.getProperty()),getEntityString(event.getConcept()),new Integer(event.getCardinality()) });
        }
        public void visit(SetMaximumCardinality event) throws KAONException {
            createNode(event,new Object[] { getEntityString(event.getProperty()),getEntityString(event.getConcept()),new Integer(event.getCardinality()) });
        }
        public void visit(AddSubProperty event) throws KAONException {
            createNode(event,new Object[] { getEntityString(event.getSuperProperty()),getEntityString(event.getSubProperty()) });
        }
        public void visit(RemoveSubProperty event) throws KAONException {
            createNode(event,new Object[] { getEntityString(event.getSuperProperty()),getEntityString(event.getSubProperty()) });
        }
        public void visit(SetInverseProperties event) throws KAONException {
            createNode(event,new Object[] { getEntityString(event.getProperty1()),getEntityString(event.getProperty2()) });
        }
        public void visit(SetNoInverseProperties event) throws KAONException {
            createNode(event,new Object[] { getEntityString(event.getProperty1()),getEntityString(event.getProperty2()) });
        }
        public void visit(SetPropertySymmetric event) throws KAONException {
            createNode(event,event.getSymmetric() ? "true" : "false",new Object[] { getEntityString(event.getProperty()) });
        }
        public void visit(SetPropertyTransitive event) throws KAONException {
            createNode(event,event.getTransitive() ? "true" : "false",new Object[] { getEntityString(event.getProperty()) });
        }
        public void visit(AddInstanceOf event) throws KAONException {
            createNode(event,new Object[] { getEntityString(event.getConcept()),getEntityString(event.getInstance()) });
        }
        public void visit(RemoveInstanceOf event) throws KAONException {
            createNode(event,new Object[] { getEntityString(event.getConcept()),getEntityString(event.getInstance()) });
        }
        public void visit(AddPropertyInstance event) throws KAONException {
            createNode(event,getPropertyInstanceParameters(event.getPropertyInstance()));
        }
        public void visit(RemovePropertyInstance event) throws KAONException {
            createNode(event,getPropertyInstanceParameters(event.getPropertyInstance()));
        }
        public void visit(SetPropertyInstanceValue event) throws KAONException {
            createNode(event,getPropertyInstanceParameters(event.getPropertyInstance()));
        }
        public void visit(ChangePropertyInstanceValue event) throws KAONException {
            Object[] values=getPropertyInstanceParameters(event.getPropertyInstance());
            String newValue;
            if (event.getNewTargetValue() instanceof Instance)
                newValue=getEntityString((Instance)event.getNewTargetValue());
            else
                newValue=event.getNewTargetValue().toString();
            createNode(event,new Object[] { values[0],values[1],values[2],newValue });
        }
        public void visit(AddIncludedOIModel event) throws KAONException {
            createNode(event,new Object[] { event.getIncludedOIModel().getLogicalURI(),m_oimodelerViewable.getOIModel().getLogicalURI() });
        }
        public void visit(RemoveIncludedOIModel event) throws KAONException {
            createNode(event,new Object[] { event.getIncludedOIModel().getLogicalURI(),m_oimodelerViewable.getOIModel().getLogicalURI() });
        }
        protected Object[] getPropertyInstanceParameters(PropertyInstance propertyInstance) throws KAONException {
            if (propertyInstance.getTargetValue() instanceof Instance)
                return new Object[] { getEntityString(propertyInstance.getProperty()),getEntityString(propertyInstance.getSourceInstance()),getEntityString((Instance)propertyInstance.getTargetValue()) };
            else
                return new Object[] { getEntityString(propertyInstance.getProperty()),getEntityString(propertyInstance.getSourceInstance()),propertyInstance.getTargetValue() };
        }
        protected String getEntityString(Entity entity) throws KAONException {
            String label=entity.getLabel(m_oimodelerViewable.getLanguageURI());
            if (label==null)
                label=m_oimodelerViewable.getOIModelGraph().replaceURIPrefix(entity.getURI());
            return label;
        }
    }
}
