package de.fzi.wim.oimodeler.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import de.fzi.wim.guibase.localization.LocalizationManager;
import de.fzi.wim.oimodeler.OIModelerModule;

/**
 * Simple dialog for editing Documentation of an entity.
 */
public class DocumentationEditDlg extends JDialog {

    /** Editor for the documentation. */
    protected JTextArea m_docEditor;

    /** Set to <code>true</code> if dialog is contirmed. */
    protected boolean m_confirmed;

    public DocumentationEditDlg(OIModelerModule oimodelerModule, final String orig_doc) {
        super(oimodelerModule.getAppDriver().getMainFrameWindow(), true);
        LocalizationManager localizationManager = oimodelerModule.getAppDriver().getLocalizationManager();

        setTitle(localizationManager.getPhrase("oimodeler.editDocumentation.title"));

        setDefaultCloseOperation(DISPOSE_ON_CLOSE);
        m_docEditor = new JTextArea(orig_doc, 10, 50);

        m_docEditor.setLineWrap(true);
        m_docEditor.setWrapStyleWord(true);
        JScrollPane m_docScroll = new JScrollPane(m_docEditor);
        m_docScroll.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);

        JButton okButton = localizationManager.getButton("oimodeler.OK");
        okButton.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                m_confirmed = true;
                dispose();
            }
        });
        JButton cancelButton = localizationManager.getButton("oimodeler.cancel");
        cancelButton.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                dispose();
            }
        });
        JPanel editorPane = new JPanel();
        editorPane.setLayout(new BoxLayout(editorPane, BoxLayout.Y_AXIS));
        JLabel label;
        label = localizationManager.getLabel("oimodeler.editDocumentationName.label");
        label.setAlignmentX(Component.LEFT_ALIGNMENT);
        editorPane.add(label);
        editorPane.add(Box.createRigidArea(new Dimension(0, 5)));
        m_docScroll.setAlignmentX(Component.LEFT_ALIGNMENT);
        editorPane.add(m_docScroll);
        editorPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel buttonsPane = new JPanel(new FlowLayout(FlowLayout.RIGHT));
        buttonsPane.add(okButton);
        buttonsPane.add(cancelButton);
        buttonsPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        getContentPane().add(editorPane, BorderLayout.CENTER);
        getContentPane().add(buttonsPane, BorderLayout.SOUTH);
        pack();
        setLocationRelativeTo(oimodelerModule.getAppDriver().getMainFrameWindow());
    }

    /**
     * Returns the new documentation text
     * 
     * @return name of the new entity
     */
    public String getDocumentation() {
        return m_docEditor.getText();
    }

    /**
     * Returns whether dialog was confirmed with OK.
     * 
     * @return <code>true</code> if the dialog was confirmed
     */
    public boolean isConfirmed() {
        return m_confirmed;
    }

}